% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hip.point.r
\name{hip.point}
\alias{hip.point}
\title{hip.point - Halton Iterative Partition (HIP) of point resources.}
\usage{
hip.point(x, n, J = NULL, plot.lattice = FALSE)
}
\arguments{
\item{x}{A \code{SpatialPoints} or \code{SpatialPointsDataFrame} object
representing the 2-dimensional point resource
from which samples are taken. 
This object must contain at least 1 point.}

\item{n}{Sample size.  The number locations to draw from the set of points
contained in \code{x}. If the sample size returned is less than the desired sample size,
increase \code{n} until the desired sample size is reached.}

\item{J}{A 2X1 vector of base powers.  \code{J[1]} is for horizontal,
\code{J[2]} for vertical dimension. \code{J} determines the size and shape
of the smallest Halton boxes. There are \code{bases[1]^J[1]} vertical columns 
of Halton boxes over \code{x}'s bounding box, and \code{bases[2]^J[2]} 
horizontal rows of Halton boxes over the bounding box, for a total 
of \code{prod(bases^J)} boxes.  The dimension of each box is 
\code{c(dx,dy)/} \code{(bases^J)}, where \code{c(dx,dy)} are the horizontal and 
vertical extents of \code{x}'s bounding box.  If \code{J=NULL} (the default),
\code{J} is chosen so that Halton boxes are as square as possible.}

\item{plot.lattice}{Boolean. If TRUE, plots the sample drawn with corresponding halton lattice.}
}
\value{
A \code{SpatialPoints} objects containing locations in the 
HIP sample, in HIP order.

Additional attributes of the output object, beyond those which 
make it a \code{SpatialPoints}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "point").
   \item \code{sample.type}: Type of sample drawn. (i.e., "HIP").
   
   \item \code{J}: Exponents of the bases used to form the lattice of 
   Halton boxes. This is either the input \code{J}, or the \code{J} vector
   computed by \code{\link{halton.indices}}.  
   
   \item \code{bases}: Bases of the Halton sequence used to draw the sample. 
   
   \item \code{hl.bbox}: The bounding box around points in \code{x} used to 
   draw the sample.  See \code{\link{halton.indices}}.
 
}
}
\description{
Draws a Halton Iterative Partition (HIP) sample from a 
\code{SpatialPoints*} object.
}
\details{
\bold{A brief description of Halton Iterative Partition (HIP) sampling for points:} 
Given a set of Halton Iterative Partition parameters
\code{x} (SpatialPoints* object) and \code{n} (sample size),
a lattice of Halton boxes is constructed iteratively over the bounding box 
of \code{x}.  
This results in enough Halton boxes on the bounding box to uniquely 
cover the point resource.  That is, one and only one point per 
box.   
The Halton index (the inverse of the Halton sequence) of all boxes 
is computed and assigned to points that lie 
in each box. Finally, a random number between 0 and the largest Halton index is 
drawn, and the next \code{n} points associated with the 
next \code{n} Halton boxes are taken as 
the sample, wrapping to the beginning if necessary.
}
\examples{

#   Draw sample of cities in the state of Washington
data(WA.cities)
samp <- hip.point( WA.cities, 100 )
  
}
\seealso{
\code{\link{hip.polygon}}, \code{\link{SDraw}}, 
\code{\link{bas.point}}
}
\author{
Michael Kleinsasser\cr
Aidan McDonald
}
\keyword{design}
\keyword{survey}
