% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDraw-package.r
\docType{package}
\name{SDraw-package}
\alias{SDraw-package}
\alias{_PACKAGE}
\alias{BAS-package}
\alias{HAL-package}
\alias{GRTS}
\alias{SSS-package}
\alias{SDraw}
\alias{SRS}
\title{Selection of spatially balanced samples.}
\description{
SDraw provides a set of R functions that draw
Halton-Lattice samples (HAL),
Balanced-Acceptance-Samples (BAS), 
Generalized-Random-Tessellation-Stratified (GRTS) samples, 
Simple-Systematic-Samples (SSS), and 
Simple-Random-Samples (SRS).  The types of input 
frames accepted are points (0-D, finite), lines (1-D, infinite), or polygons (2-D,
infinite). 

\tabular{ll}{ Package: 
\tab SDraw\cr 
Type: \tab Package\cr 
License: \tab GNU General Public License\cr 
Imports: \tab spsurvey,utils,rgdal,rgeos,graphics,
methods,deldir,OpenStreetMap,stats \cr
Depends: \tab sp \cr
} 


The work-horse functions are named \code{???.point}, \code{???.line}, and 
\code{???.polygon}, where '\code{???}' is either \code{hal}, \code{bas}, \code{grts}, 
\code{sss}, or \code{srs}.  For simplicity, an S4 generic, 
\code{sdraw}, is provided to handle all combinations of sample and frame types 
(see \code{\link{sdraw}}).
}
\references{
Manly, B. F. J. and Navarro-Alberto, J. A., editors, (2015), "Introduction to Ecological Sampling", 
CRC Press, Boca Raton, FL. 

Robertson, B.L., J. A. Brown, T. L. McDonald, and P. Jaksons
(2013) "BAS: Balanced Acceptance Sampling of Natural Resources", Biometrics,
v69, p. 776-784.

Stevens, D. L., Jr. and A. R. Olsen (2004) "Spatially balanced sampling of
natural resources." Journal of the American Statistical Association 99,
262-278.
}
\seealso{
\code{\link{sdraw}}, \code{\link{bas.polygon}}, \code{\link{bas.line}}, \code{\link{bas.point}},
\code{\link{hip.polygon}}, \code{\link{hip.point}}, 
\code{\link{sss.line}}, \code{\link{sss.polygon}},
\code{\link{grts.polygon}}, \code{\link{grts.line}}, \code{\link{grts.point}}
documentation for package \code{sp}.
}
\author{
Trent McDonald \code{tmcdonald@west-inc.com}. The GRTS routine comes from
package \code{spsurvey}.
}
\keyword{package}
