% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmix.R
\name{rmix}
\alias{rmix}
\title{Mixture distribution}
\usage{
rmix(n, q = 0.01, h = 10, sigma = 1)
}
\arguments{
\item{n}{sample size, numeric.}

\item{q}{probability that observation is drawn from the contamination distribution, numeric.}

\item{h}{mean of the contamination distribution, numeric.}

\item{sigma}{standard deviation of the contamination distribution, numeric.}
}
\value{
Numeric vector of length n containing the random sample.
}
\description{
Generates a random sample from a mixture normal distribution.
}
\details{
The resulting sample is drawn from the distribution
\deqn{(1 - q)\mathcal{N}(0, 1)\; + \; q \mathcal{N}(h, \sigma^2).}
}
\examples{
# random sample with 0.01 chance of contamination distribution with mean 10
rmix(100)

# random sample with 0.01 chance of contamination distribution with standard deviation 10
# IMPORTANT: h needs to be set to 0!
rmix(100, h = 0, sigma = 1)

}
