% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrink.R
\name{plot.shrink}
\alias{plot.shrink}
\title{Plot shrink object}
\usage{
\method{plot}{shrink}(x, type = c("line", "heatmap"), footnote = TRUE, ...)
}
\arguments{
\item{x}{class object shrink.}

\item{type}{produce either 'heatmap' or 'line' graph}

\item{footnote}{option to print footnote of optimal values. Defaults to TRUE.}

\item{...}{additional arguments.}
}
\description{
Produces a plot for the cross validation errors, if available.
}
\examples{
# generate some data
data = data_gen(n = 100, p = 5, r = 1)

# lasso penalized beta (print estimated omega)
lam.max = max(abs(t(data$X) \%*\% data$Y))
(shrink = shrink(X = data$X, Y = data$Y, B = cov(data$X, data$Y), lam.max = lam.max))

# print estimated beta
shrink$Z

# create heatmap of CV errors
plot(shrink, type = 'heatmap')

# create line graph of CV errors
plot(shrink)
}
