% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.MRec.R
\name{MRec}
\alias{MRec}
\title{MRec (Matrix Recorrelation) method}
\description{
Perform a multivariate bias correction with Gaussian assumption.
}
\details{
Only pearson correlations are corrected.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period

## Bias correction
## Step 1 : construction of the class MRec 
mrec = SBCK::MRec$new() 
## Step 2 : Fit the bias correction model
mrec$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction, Z is a list containing corrections.
Z = mrec$predict(X1,X0) ## X0 is optional, in this case Z0 is NULL
Z$Z0 ## Correction in calibration period
Z$Z1 ## Correction in projection period

}
\references{
Bárdossy, A. and Pegram, G.: Multiscale spatial recorrelation of
            RCM precipitation to produce unbiased climate change scenarios
            over large areas and small, Water Resources Research, 48, 9502–,
            https://doi.org/10.1029/2011WR011524, 2012.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_features}}{[integer] Numbers of features}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MRec$new()}}
\item \href{#method-fit}{\code{MRec$fit()}}
\item \href{#method-predict}{\code{MRec$predict()}}
\item \href{#method-clone}{\code{MRec$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new MRec object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MRec$new(distY = NULL, distX = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distY}}{[A list of ROOPSD distribution or NULL] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is empirical.}

\item{\code{distX}}{[A list of ROOPSD distribution or NULL] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is empirical.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `MRec` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MRec$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MRec$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MRec$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
