% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.ECBC.R
\name{ECBC}
\alias{ECBC}
\title{ECBC (Empirical Copula Bias Correction) method}
\description{
Perform a multivariate (non stationary) bias correction.
}
\details{
use Schaake shuffle
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period


## Bias correction
## Step 1 : construction of the class ECBC
ecbc = SBCK::ECBC$new() 
## Step 2 : Fit the bias correction model
ecbc$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction
Z = ecbc$predict(X1,X0) 

}
\references{
Vrac, M. and P. Friederichs, 2015: Multivariate—Intervariable,
            Spatial, and Temporal—Bias Correction. J. Climate, 28, 218–237,
            https://doi.org/10.1175/JCLI-D-14-00059.1
}
\section{Super class}{
\code{\link[SBCK:CDFt]{SBCK::CDFt}} -> \code{ECBC}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ECBC$new()}}
\item \href{#method-fit}{\code{ECBC$fit()}}
\item \href{#method-predict}{\code{ECBC$predict()}}
\item \href{#method-clone}{\code{ECBC$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new ECBC object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ECBC$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{This class is based to CDFt, and takes the same arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `ECBC` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ECBC$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ECBC$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ECBC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
