% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external-generic.R
\name{new_external_generic}
\alias{new_external_generic}
\title{Generics in other packages}
\usage{
new_external_generic(package, name, dispatch_args, version = NULL)
}
\arguments{
\item{package}{Package the generic is defined in.}

\item{name}{Name of generic, as a string.}

\item{dispatch_args}{Character vector giving arguments used for dispatch.}

\item{version}{An optional version the package must meet for the method to
be registered.}
}
\value{
An S7 external generic, i.e. a list with class
\code{S7_external_generic}.
}
\description{
You need an explicit external generic when you want to provide methods
for a generic (S3, S4, or S7) that is defined in another package, and you
don't want to take a hard dependency on that package.

The easiest way to provide methods for generics in other packages is
import the generic into your \code{NAMESPACE}. This, however, creates a hard
dependency, and sometimes you want a soft dependency, only registering the
method if the package is already installed. \code{new_external_generic()} allows
you to provide the minimal needed information about a generic so that methods
can be registered at run time, as needed, using \code{\link[=methods_register]{methods_register()}}.

Note that in tests, you'll need to explicitly call the generic from the
external package with \code{pkg::generic()}.
}
\examples{
my_class <- new_class("my_class")

your_generic <- new_external_generic("stats", "median", "x")
method(your_generic, my_class) <- function(x) "Hi!"
}
