% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgDijkstra.r
\name{vcgDijkstra}
\alias{vcgDijkstra}
\title{Compute pseudo-geodesic distances on a triangular mesh}
\usage{
vcgDijkstra(x, vertpointer, maxdist = NULL)
}
\arguments{
\item{x}{triangular mesh of class \code{mesh3d}}

\item{vertpointer}{integer: references indices of vertices on the mesh, typically only a single query vertex.}

\item{maxdist}{positive scalar double, the maximal distance to travel along the mesh when computing distances. Leave at \code{NULL} to traverse the full mesh. This can be used to speed up the computation if you are only interested in geodesic distances to neighbors within a limited distance around the query vertices.}
}
\value{
returns a vector of shortest distances for each of the vertices to one of the vertices referenced in \code{vertpointer}. If \code{maxdis}t is in use (not \code{NULL}), the distance values for vertices outside the requested \code{maxdist} are not computed and appear as \code{0}.
}
\description{
Compute pseudo-geodesic distances on a triangular mesh
}
\note{
Make sure to have a clean manifold mesh. Note that this computes the length of the pseudo-geodesic path (following the edges) between the two vertices.
}
\examples{
## Compute geodesic distance between all mesh vertices and the first vertex of a mesh
data(humface)
geo <- vcgDijkstra(humface,1)
if (interactive()) {
require(Morpho);require(rgl)
meshDist(humface,distvec = geo)
spheres3d(vert2points(humface)[1,],col=2)
}
}
