% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{computeAnnualMaxima}
\alias{computeAnnualMaxima}
\title{computeAnnualMaxima}
\usage{
computeAnnualMaxima(timeAndSeries)
}
\arguments{
\item{timeAndSeries}{A matrix or data frame containing the time stamps and
series values. The first column should contain the time stamps and the
second column should contain the series values.}
}
\value{
A list containing the annual maximum values, their corresponding dates,
and their indices.
\describe{
\item{\code{annualMax}}{A numeric vector of annual maximum values.}
\item{\code{annualMaxDate}}{A vector of dates corresponding to the annual
maximum values.}
\item{\code{annualMaxIndx}}{A vector of indices indicating the positions
of the annual maximum values in the original time series.}
}
}
\description{
\code{computeAnnualMaxima} is a function that computes the annual maxima of
a time series.
}
\examples{
timeAndSeries <- ArdecheStMartin
computeAnnualMaxima(timeAndSeries)
}
