% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_path.R
\name{read_path}
\alias{read_path}
\title{Read path coordinates from raw data formats.}
\usage{
read_path(
  filename,
  arena,
  id = NULL,
  track.format = "none",
  track.index = NULL,
  interpolate = FALSE
)
}
\arguments{
\item{filename}{A raw data file containing path coordinates. See details for
supported formats.}

\item{arena}{The \code{arena} object associated with this track. This is
required to calibrate the track coordinates to the coordinate space of the
arena.}

\item{id}{An optional name for the experiment. Default is to generate this
from the filename provided.}

\item{track.format}{The format of the raw file.}

\item{track.index}{Only for formats where multiple tracks are stored in one
file (ignored otherwise). This parameter indicates which section of the
file corresponds to the track to be read. The exact usage depends on the
format being read.}

\item{interpolate}{Should missing data points be interpolated. Default is
\code{FALSE}. Interpolation is not yet implemented.}
}
\value{
An \code{rtrack_path} object containing the extracted swim path. This
  is a list comprised of the components \code{raw.t} (timestamp),
  \code{raw.x} (x coordinates), \code{raw.y} (y coordinates),\code{t},
  \code{x} and \code{y} (normalised, cleaned and possibly interpolated
  coordinates).
}
\description{
The user will normally not need to call this directly. Use
\code{\link{read_experiment}} instead.
}
\details{
Raw data from several sources can be read in directly. The formats currently
supported are 'ethovision.xt.excel' (for swim paths exported from the latest
Ethovision software), 'ethovision.3.csv' (for data exported from the older
Ethovision version 3) and 'raw.csv'. The 'raw.csv' format is a simple
comma-delimited text file containing three columns 'Time', 'X' and 'Y'. The
timestamp values in 'Time' should be in seconds from the start of the trial
recording and coordinates should be in real-world units (e.g. cm, in).
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.csv", package = "Rtrack")
arena_description <- system.file("extdata", "Arena_SW.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "ethovision.3.csv")

}
\seealso{
\code{\link{read_arena}}, and also \code{\link{read_experiment}} for
  processing many tracks at once.
}
