% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dasubbo}
\alias{dasubbo}
\title{Returns density from the AEP Distribution}
\usage{
dasubbo(x, m = 0, al = 1, ar = 1, bl = 2, br = 2)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter.}

\item{al, ar}{(numeric) - scale parameters. Must be in the range
\eqn{(0, \infty)}.}

\item{bl, br}{(numeric) - shape parameters. Must be in the range
\eqn{(0, \infty)}.}
}
\value{
a vector containing the values for the densities.
}
\description{
The \code{dasubbo} returns the density at point x for the
AEP distribution with parameters \eqn{a*}, \eqn{b*}, \eqn{m}. Notice
that the function can generate RNGs for both the \code{subboafit} and
\code{subbolafit} routines.
}
\details{
The AEP is a exponential power distribution controlled
by five parameters, with formula:
\deqn{ f(x;a_l,a_r,b_l,b_r,m) =
\frac{1}{A} e^{- \frac{1}{b_l} |\frac{x-m}{a_l}|^{b_l} }, x < m
}
\deqn{ f(x;a_l,a_r,b_l,b_r,m) =
\frac{1}{A} e^{- \frac{1}{b_r} |\frac{x-m}{a_r}|^{b_r} }, x > m
}
with:
\deqn{A = a_lb_l^{1/b_l}\Gamma(1+1/b_l) + a_rb_r^{1/b_r}\Gamma(1+1/b_r)}
where \eqn{l} and \eqn{r} represent left and right tails, \eqn{a*} are
scale parameters, \eqn{b*} control the tails (lower values represent
fatter tails), and \eqn{m} is a location parameter.
}
