% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainExtSVM.R
\name{tuneandtrainExtSVM}
\alias{tuneandtrainExtSVM}
\title{Tune and Train External SVM}
\usage{
tuneandtrainExtSVM(
  data,
  dataext,
  kernel = "linear",
  cost_seq = 2^(-15:15),
  scale = FALSE
)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the response 
variable (factor), and the remaining columns should be the predictor variables.}

\item{kernel}{A character string specifying the kernel type to be used in the SVM. Default is "linear".}

\item{cost_seq}{A numeric vector of cost values to be evaluated. Default is `2^(-15:15)`.}

\item{scale}{A logical indicating whether to scale the predictor variables. Default is FALSE.}
}
\value{
A list containing the best cost value (`best_cost`), the final trained model (`best_model`), 
  the AUC on the training data (`final_auc`).
}
\description{
This function tunes and trains a Support Vector Machine (SVM) classifier using the \code{mlr} package. 
The function evaluates a sequence of cost values on an external validation dataset and selects 
the best model based on the Area Under the Curve (AUC).
}
\details{
In Support Vector Machines, The \code{cost} parameter controls the trade-off between 
achieving a low training error and a low testing error. 
This function trains an SVM model on the training dataset and validates it using the external validation dataset. 
The cost value that results in the highest AUC on the external validation dataset is chosen as the best model.
}
\examples{
\donttest{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage
result <- tuneandtrainExtSVM(sample_data_train, sample_data_extern, kernel = "linear", 
  cost_seq = 2^(-15:15), scale = FALSE)
result$best_cost
result$best_model
result$final_auc
}
}
