% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{h_log_hr_est_via_score}
\alias{h_log_hr_est_via_score}
\title{Estimate Log Hazard Ratio via Score Function}
\usage{
h_log_hr_est_via_score(score_fun, interval = c(-5, 5), ...)
}
\arguments{
\item{score_fun}{(\code{function}) The log-rank score function to be used for estimation.}

\item{interval}{(\code{numeric}) A numeric vector of length 2 specifying the interval in which to search for the root.}

\item{...}{Additional arguments passed to \code{score_fun}.}
}
\value{
A list containing:
\itemize{
\item \code{theta}: The estimated log hazard ratio.
\item \code{se}: The standard error of the estimated log hazard ratio.
\item \code{sigma_L2}: The variance of the log-rank statistic.
\item \code{n}: The number of observations used in the calculation.
}
}
\description{
This function estimates the log hazard ratio by finding the root of the log-rank score function.
}
\details{
This deactivates the ties factor correction in the score function by passing
\code{use_ties_factor = FALSE} to the \code{score_fun}. The root finding is done without calculating
the variance by passing \code{calculate_variance = FALSE}, which is only calculated at the solution.
This saves computation time, and avoids spurious warnings about negative variances during the root
finding process.
}
\keyword{internal}
