% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\alias{diagnostics_autocorrelation}
\alias{diagnostics_trace}
\alias{diagnostics_density}
\title{Visualizes MCMC diagnostics for a fitted RoBSA object}
\usage{
diagnostics(
  fit,
  parameter = NULL,
  type,
  plot_type = "base",
  show_models = NULL,
  lags = 30,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)

diagnostics_autocorrelation(
  fit,
  parameter = NULL,
  plot_type = "base",
  show_models = NULL,
  lags = 30,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)

diagnostics_trace(
  fit,
  parameter = NULL,
  plot_type = "base",
  show_models = NULL,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)

diagnostics_density(
  fit,
  parameter = NULL,
  plot_type = "base",
  show_models = NULL,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)
}
\arguments{
\item{fit}{a fitted RoBSA object}

\item{parameter}{a parameter to be plotted.}

\item{type}{type of MCMC diagnostic to be plotted.
Options are \code{"trace"} for the chains' trace plots,
\code{"autocorrelation"} for autocorrelation of the
chains, and \code{"densities"} for the overlaying
densities of the individual chains. Can be abbreviated to
first letters.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{show_models}{MCMC diagnostics of which models should be
plotted. Defaults to \code{NULL} which plots MCMC diagnostics
for a specified parameter for every model that is part of the
ensemble.}

\item{lags}{number of lags to be shown for
\code{type = "autocorrelation"}. Defaults to \code{30}.}

\item{title}{whether the model number should be displayed in title.
Defaults to \code{TRUE} when more than one model is selected.}

\item{...}{additional arguments to be passed to the plotting functions.}
}
\value{
\code{diagnostics} returns either \code{NULL} if \code{plot_type = "base"}
or an object/list of objects (depending on the number of parameters to be plotted)
of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{diagnostics} creates visual
checks of individual models convergence. Numerical
overview of individual models can be obtained by
\code{summary(object, type = "diagnostics")},
or even more detailed information by
\code{summary(object, type = "individual")}.
}
\seealso{
\code{\link[=RoBSA]{RoBSA()}}, \code{\link[=summary.RoBSA]{summary.RoBSA()}}
}
