% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiBMA.R
\name{update.BiBMA}
\alias{update.BiBMA}
\title{Updates a fitted BiBMA object}
\usage{
\method{update}{BiBMA}(
  object,
  refit_failed = TRUE,
  extend_all = FALSE,
  prior_effect = NULL,
  prior_heterogeneity = NULL,
  prior_baseline = NULL,
  prior_weights = NULL,
  prior_effect_null = NULL,
  prior_heterogeneity_null = NULL,
  prior_baseline_null = NULL,
  study_names = NULL,
  chains = NULL,
  adapt = NULL,
  burnin = NULL,
  sample = NULL,
  thin = NULL,
  autofit = NULL,
  parallel = NULL,
  autofit_control = NULL,
  convergence_checks = NULL,
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted BiBMA object}

\item{refit_failed}{whether failed models should be refitted. Relevant only
if new priors or \code{prior_weights} are not supplied. Defaults to \code{TRUE}.}

\item{extend_all}{extend sampling in all fitted models based on \code{"sample_extend"}
argument in \code{\link[=set_autofit_control]{set_autofit_control()}} function. Defaults to \code{FALSE}.}

\item{prior_effect}{prior distribution for the effect size (\code{mu})
parameter that will be treated as belonging to the alternative hypothesis.
Defaults to \code{NULL}.}

\item{prior_heterogeneity}{prior distribution for the heterogeneity \code{tau}
parameter that will be treated as belonging to the alternative hypothesis.
Defaults to \code{NULL}.}

\item{prior_baseline}{prior distribution for the intercepts (\code{pi}) of each study
that will be treated as belonging to the alternative hypothesis. Defaults to \code{NULL}.}

\item{prior_weights}{either a single value specifying prior model weight
of a newly specified model using priors argument, or a vector of the
same length as already fitted models to update their prior weights.}

\item{prior_effect_null}{prior distribution for the effect size (\code{mu})
parameter that will be treated as belonging to the null hypothesis.
Defaults to \code{NULL}.}

\item{prior_heterogeneity_null}{prior distribution for the heterogeneity \code{tau}
parameter that will be treated as belonging to the null hypothesis.
Defaults to \code{NULL}.}

\item{prior_baseline_null}{prior distribution for the intercepts (\code{pi}) of each study
that will be treated as belonging to the null hypothesis. Defaults to \code{NULL}.}

\item{study_names}{an optional argument with the names of the studies}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{adapt}{a number of adaptation iterations of the MCMC algorithm.
Defaults to \code{500}.}

\item{burnin}{a number of burnin iterations of the MCMC algorithm.
Defaults to \code{2000}.}

\item{sample}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{autofit}{whether the model should be fitted until the convergence
criteria (specified in \code{autofit_control}) are satisfied. Defaults to
\code{TRUE}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{autofit_control}{allows to pass autofit control settings with the
\code{\link[=set_autofit_control]{set_autofit_control()}} function. See \code{?set_autofit_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{BiBMA} returns an object of class 'BiBMA'.
}
\description{
\code{update.BiBMA} can be used to
\enumerate{
\item{add an additional model to an existing \code{"BiBMA"} object by
specifying either a null or alternative prior for each parameter
and the prior odds of the model (\code{prior_weights}), see the
\code{vignette("CustomEnsembles")} vignette,}
\item{change the prior odds of fitted models by specifying a vector
\code{prior_weights} of the same length as the fitted models,}
\item{refitting models that failed to converge with updated settings
of control parameters,}
\item{or changing the convergence criteria and recalculating the ensemble
results by specifying new \code{control} argument and setting
\code{refit_failed == FALSE}.}
}
}
\details{
See \code{\link[=BiBMA]{BiBMA()}} for more details.
}
\seealso{
\code{\link[=BiBMA]{BiBMA()}}, \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=prior]{prior()}}, \code{\link[=check_setup]{check_setup()}}
}
