% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{effect_sizes}
\alias{effect_sizes}
\alias{d2r}
\alias{d2logOR}
\alias{r2d}
\alias{r2z}
\alias{logOR2d}
\alias{z2r}
\alias{d2z}
\alias{r2logOR}
\alias{logOR2z}
\alias{logOR2r}
\alias{z2d}
\alias{z2logOR}
\title{Effect size transformations}
\usage{
d2r(d)

d2logOR(d)

r2d(r)

r2z(r)

logOR2d(logOR)

z2r(z)

d2z(d)

r2logOR(r)

logOR2z(logOR)

logOR2r(logOR)

z2d(z)

z2logOR(z)
}
\arguments{
\item{d}{Cohen's d.}

\item{r}{correlation coefficient.}

\item{logOR}{log(odds ratios).}

\item{z}{Fisher's z.}
}
\description{
Functions for transforming between different
effect size measures.
}
\details{
All transformations are based on
\insertCite{borenstein2011introduction}{RoBMA}. In case that
a direct transformation is not available, the transformations
are chained to provide the effect size of interest.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=standard_errors]{standard_errors()}}, \code{\link[=sample_sizes]{sample_sizes()}}
}
