% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{weightedt}
\alias{weightedt}
\alias{dwt}
\alias{pwt}
\alias{qwt}
\alias{rwt}
\title{Weighted t distribution}
\usage{
dwt(
  x,
  df,
  ncp,
  steps = if (!is.null(crit_t)) NULL,
  omega,
  crit_t = if (!is.null(steps)) NULL,
  type = "two.sided",
  log = FALSE
)

pwt(
  q,
  df,
  ncp,
  steps = if (!is.null(crit_t)) NULL,
  omega,
  crit_t = if (!is.null(steps)) NULL,
  type = "two.sided",
  lower.tail = TRUE,
  log.p = FALSE
)

qwt(
  p,
  df,
  ncp,
  steps = if (!is.null(crit_t)) NULL,
  omega,
  crit_t = if (!is.null(steps)) NULL,
  type = "two.sided",
  lower.tail = TRUE,
  log.p = FALSE
)

rwt(
  n,
  df,
  ncp,
  steps = if (!is.null(crit_t)) NULL,
  omega,
  crit_t = if (!is.null(steps)) NULL,
  type = "two.sided"
)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{df}{degrees of freedom (> 0, maybe non-integer).
\code{df = Inf} is allowed.}

\item{ncp}{non-centrality parameter delta.}

\item{steps}{vector of steps for the weight function.}

\item{omega}{vector of weights defining the probability
of observing a t-statistics between each of the two steps.}

\item{crit_t}{vector of t-values defining steps
(if \code{steps} are not supplied).}

\item{type}{type of weight function (defaults to \code{"two.sided"}).}

\item{log, log.p}{logical; if \code{TRUE}, probabilities
\code{p} are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities
are \eqn{P[X \le x]}, otherwise, \eqn{P[X \ge x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length
is taken to be the number required.}
}
\description{
Density, distribution function, quantile function
and random generation for the weighted t distribution with
\code{df} degrees of freedom, non-centrality parameter
\code{ncp}, steps \code{steps} (or critical t-values
\code{crit_t}), and weights \code{omega}.
}
\details{
The \code{df}, \code{ncp}, \code{steps}, \code{omega} can be
supplied as a vectors (\code{df}, \code{ncp}) or matrices (\code{steps},
\code{omega}) with length / number of rows equal to \code{x}/\code{q}/
\code{p}. Otherwise, they are recycled to the length of the result.

The functions quickly lose precision in the tails since they depend on
sums of distribution functions of t distibution
\code{\link[stats:TDist]{stats::pt}}. In cases where the density of
t distribution cannot be computed by \code{\link[stats:TDist]{stats::dt}},
the implementation switches to \code{\link[DPQ:dnt]{DPQ::dnt}}.
}
\seealso{
\link[stats]{Normal}, \link[DPQ]{dnt}
}
