% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\title{Checks a fitted RoBMA object}
\usage{
diagnostics(
  fit,
  parameter,
  type,
  plot_type = "base",
  show_figures = if (parameter == "omega") -1 else NULL,
  show_models = NULL,
  par_transform = TRUE,
  lags = 30,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)
}
\arguments{
\item{fit}{a fitted RoBMA object}

\item{parameter}{a parameter to be plotted. Either
\code{"mu"}, \code{"tau"}, \code{"theta"}, or
\code{"omega"}.}

\item{type}{what type of model check should be plotted.
Options are \code{"chains"} for the chains trace plots,
\code{"autocorrelation"} for autocorrelation of the
chains, and \code{"densities"} for the overlaying
densities of the individual chains.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot2"} for plotting. The later
requires \pkg{ggplot2} package to be installed.}

\item{show_figures}{which figures should be returned in case of
multiple plots are generated. Useful when
\code{parameter = "omega"} when a plot for each parameter would be
generated. Can be also used for \code{parameter = "theta"} to
obtain only a specific subset of thetas. Set to \code{NULL}
to show all parameters (default for \code{parameter = "theta"}).}

\item{show_models}{diagnostics for which models should be produced.
Defaults to \code{NULL} that shows diagnostics to all models.}

\item{par_transform}{whether the figures should be produced for the
par_transform parameters. Defaults to \code{TRUE}.}

\item{lags}{number of lags to be shown for
\code{type = "autocorrelation"}. Defaults to \code{30}.}

\item{title}{whether the model number should be displayed in title.
Defaults to \code{TRUE} when more than one model is selected.}

\item{...}{additional arguments to be passed to
\link[graphics]{par} if \code{plot_type = "base"}.}
}
\description{
\code{diagnostics} creates visual
checks of individual models convergence. Numerical
overview of individual models can be obtained by
\code{summary(object, type = "models", diagnostics = TRUE)},
or even more detailed information by
\code{summary(object, type = "individual")}.
}
\details{
The visualization functions are based on
\link[rstan]{stan_plot} function and its color schemes.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n, study_names = Anderson2010$labels)

### ggplot2 version of all of the plots can be obtained by adding 'model_type = "ggplot"
# diagnostics function allows to visualize diagnostics of a fitted RoBMA object, for example,
# the trace plot for the mean parameter in each model model
diagnostics(fit, parameter = "mu", type = "chain")

# in order to show the trace plot only for the 11th model, add show_models parameter
diagnostics(fit, parameter = "mu", type = "chain", show_models = 11)

# furthermore, the autocorrelations
diagnostics(fit, parameter = "mu", type = "autocorrelation")

# and overlying densities for each plot can also be visualize
diagnostics(fit, parameter = "mu", type = "densities")
}
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}, \code{\link[=summary.RoBMA]{summary.RoBMA()}}
}
