% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{submit_predictions}
\alias{submit_predictions}
\title{Function to submit the Numerai Tournament predictions}
\usage{
submit_predictions(
  submission,
  location = tempdir(),
  tournament = "Nomi",
  legacy = TRUE,
  diagnostics = FALSE,
  model_id = NULL,
  prefix = tournament
)
}
\arguments{
\item{submission}{The data frame of predictions to submit. This should have two columns named "id" & "prediction"}

\item{location}{The location in which to store the predictions}

\item{tournament}{The name of the tournament, Default is Nomi and is not case-sensitive}

\item{legacy}{logical; if \code{legacy = FALSE}, submitting on super massive dataset, else submitting on old legacy format.}

\item{diagnostics}{logical; set \code{diagnostics = TRUE} to  to run diagnostics on your upload.}

\item{model_id}{Target model UUID (required for accounts with multiple models)}

\item{prefix}{The prefix to use for the submission csv file}
}
\value{
The submission id for the submission made
}
\description{
Function to submit the Numerai Tournament predictions
}
\examples{
\dontrun{
submission_id <- submit_predictions(submission_data,tournament="Nomi")
}
}
