% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnlfilename.R
\name{getNlTileTifLclNamePathOLS}
\alias{getNlTileTifLclNamePathOLS}
\title{Constructs the full path used to save/access the decompressed OLS .tif file}
\usage{
getNlTileTifLclNamePathOLS(nlType = "OLS.Y",
  configName = pkgOptions(paste0("configName_", nlType)), nlPeriod,
  tileNum)
}
\arguments{
\item{nlType}{The particular VIIRS type e.g. VIIRS.D for daily VIIRS}

\item{configName}{character the type of raster being processed}

\item{nlPeriod}{the year in which the tile was created}

\item{tileNum}{ignored}
}
\value{
a character vector filename of the .tif OLS tile
}
\description{
Constructs the full path used to save/access the decompressed OLS .tif file
}
\examples{
#using default dirNlTiles
\dontrun{
Rnightlights:::getNlTileTifLclNamePathOLS("2012", 1)
 #returns "/dataPath/tiles/OLS_2012.tif"
 }

}
