% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{readCtryPolyAdmLayer}
\alias{readCtryPolyAdmLayer}
\title{Read a country admLevel polygon}
\usage{
readCtryPolyAdmLayer(ctryCode, admLevel, polyType = "rds", dnldPoly = TRUE,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{\code{character} The ctryCode of the country of interest}

\item{admLevel}{\code{character} The name to search for}

\item{polyType}{\code{character} Whether to read the shapefile or the RDS
format.}

\item{dnldPoly}{\code{logical} If the country polygon doesn't exist 
should we download it?}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
\code{SpatialPolygonsDataFrame} The admLevel polygon layer or NULL 
    if not found
}
\description{
Read a country admLevel polygon. Reads the saved RDS format of the shapefile
    which is saved as part of \code{dnldCtryPoly} by default. Otherwise,
    it will try to read the shapefile. If it fails it returns null.
}
\examples{
\dontrun{
readCtryPolyAdmLayer("KEN", "KEN_adm1")
#returns "KEN_adm1"
}

}
