% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{listNlTiles}
\alias{listNlTiles}
\title{List locally cached tiles}
\usage{
listNlTiles(nlTypes = NULL, nlPeriods = NULL, source = "local")
}
\arguments{
\item{nlTypes}{A character vector of nlTypes to filter by}

\item{nlPeriods}{A character vector of nlPeriods to filter by}

\item{source}{Character string. Whether to check data availability.
"local" or "remote". Default is "local".}
}
\value{
a list of locally cached nlTiles or NULL
}
\description{
List the tiles which have been downloaded previously and are currently
    cached in the local tiles folder
}
\examples{
#list all tiles
listNlTiles()

#list all VIIRS tiles
listNlTiles(nlTypes = "VIIRS")

#list all VIIRS tiles available in the years 2014-2015. Note VIIRS data
#starts in 201401
listNlTiles(nlTypes = "VIIRS", nlPeriods = nlRange("201401", "201512"))

#filter data
listNlTiles(nlTypes = "OLS", nlPeriods = c("2012", "2013"))

}
