% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{harmo_process}
\alias{harmo_process}
\title{Generate harmonized dataset(s) and associated metadata}
\usage{
harmo_process(
  dossier,
  dataschema = attributes(dossier)$`Rmonize::DataSchema`,
  data_proc_elem = attributes(dossier)$`Rmonize::Data Processing Elements`,
  harmonized_col_dataset = attributes(dossier)$`Rmonize::harmonized_col_dataset`,
  harmonized_col_id = attributes(dossier)$`Rmonize::harmonized_col_id`
)
}
\arguments{
\item{dossier}{List of data frame(s) containing input dataset(s).}

\item{dataschema}{A DataSchema object.}

\item{data_proc_elem}{A Data Processing Elements object.}

\item{harmonized_col_dataset}{A character string identifying the column
to use for dataset names. NULL by default.}

\item{harmonized_col_id}{A character string identifying the name of the
column present in every dataset to use as a dataset identifier.
NULL by default.}
}
\value{
A list of data frame(s), containing harmonized dataset(s). The DataSchema
and Data Processing Elements are preserved as attributes of the
output harmonized dossier.
}
\description{
Reads a DataSchema and Data Processing Elements to generate a
harmonized dossier from input dataset(s) in a dossier and associated
metadata. The function
has one argument that can optionally be declared by the user
(\code{unique_col_dataset}). It refers to the columns which contains name of
each harmonized dataset. These two columns are added to ensure that there
is always a unique entity identifier when datasets are pooled.
}
\details{
A dossier is a named list containing one or more data frames, which are
input datasets. The name of each data frame in the dossier will be used as
the name of the associated harmonized dataset produced by \code{\link[=harmo_process]{harmo_process()}}.

A DataSchema is the list of core variables to generate across datasets and
related metadata. A DataSchema object is a list of data frames with elements
named 'Variables' (required) and 'Categories' (if any). The 'Variables'
element must contain at least the \code{name} column, and the 'Categories'
element must contain at least the \code{variable} and \code{name} columns to be usable
in any function. In 'Variables' the \code{name} column must also have unique
entries, and in 'Categories' the combination of \code{variable} and \code{name} columns
must also be unique.

The Data Processing Elements specifies the algorithms used to process input
variables into harmonized variables in the DataSchema format. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).
}
\examples{
{

# Use Rmonize_DEMO to run examples.

library(dplyr)
library(madshapR) # data_dict_filter

dataset_MELBOURNE <- Rmonize_DEMO$dataset_MELBOURNE[1]
dossier <- dossier_create(list(dataset_MELBOURNE))

dataschema <- 
  Rmonize_DEMO$`dataschema - final` \%>\%
  data_dict_filter('name == "adm_unique_id"')

data_proc_elem <- Rmonize_DEMO$`data_processing_elements - final` \%>\%
  dplyr::filter(dataschema_variable == 'adm_unique_id',
         input_dataset == 'dataset_MELBOURNE')

# perform harmonization
harmonized_dossier <- harmo_process(dossier,dataschema,data_proc_elem)
glimpse(harmonized_dossier)

}

}
