% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_github_data.R
\name{loadCallcenterData}
\alias{loadCallcenterData}
\title{Load Callcenter Data from GitHub Repository}
\format{
a dataframe with 87,600 rows and 5 variables:
\describe{
  \item{calls}{number of calls in a 6-minute aggregated interval.}
  \item{u}{numeric vector indicating the aggregated interval.}
  \item{Date}{date and time of call count recording.}
  \item{Day}{weekday associated with Date.}
  \item{Month}{month associated with Date.}
}
}
\usage{
loadCallcenterData()
}
\description{
This function retrieves the Callcenter dataset from the Rfssa_dataset repository on GitHub
(https://github.com/haghbinh/dataset/Rfssa_dataset).
The Callcenter dataset represents a small call center for an anonymous bank.
 It provides precise call timing data from January 1 to December 31, 1999.
 The data is aggregated into 6-minute intervals on each day.
 The returned object is a raw dataset in dataframe format;
 it is not a 'funts' class object.
 This raw data can then be further processed and converted into a 'funts' object named 'Callcenter'.
 See \code{\link{funts}} for more details on
 working with functional time series of class 'funts'.
}
\examples{
require(fda)
# Load Callcenter data
Call_data <- loadCallcenterData()
D <- matrix(sqrt(Call_data$calls), nrow = 240)

# Define basis functions
bs1 <- create.bspline.basis(c(0, 23), 22)

Y <- funts(X = D, basisobj = bs1)

}
\references{
\enumerate{
\item
Brown, L., Gans, N., Mandelbaum, A., Sakov, A., Shen, H., Zeltyn, S., & Zhao, L. (2005).
Statistical analysis of a telephone call center: A queueing-science perspective.
\emph{Journal of the American Statistical Association}, \strong{100}(469), 36-50.
\item
Shen, H., & Huang, J. Z. (2005).
Analysis of call center arrival data using singular value decomposition.
\emph{Applied Stochastic Models in Business and Industry}, \strong{21}(3), 251-263.
\item
Huang, J. Z., Shen, H., & Buja, A. (2008).
Functional principal components analysis via penalized rank one approximation.
\emph{Electronic Journal of Statistics}, \strong{2}, 678-695.
\item
Maadooliat, M., Huang, J. Z., & Hu, J. (2015).
Integrating data transformation in principal components analysis.
\emph{Journal of Computational and Graphical Statistics}, \strong{24}(1), 84-103.
}
}
\seealso{
\code{\link{funts}}
}
