\name{Column-wise medians}
\alias{colMedians}
\alias{colMedians_parallel}

\title{
Colum-wise medians (in parallel)
}

\description{
Colum-wise medians of a matrix
}

\usage{
colMedians(x)

colMedians_parallel(x, ncores)
}

\arguments{
\item{x}{
A matrix with the data.
}
\item{ncores}{
How many cores to use.
}
}

\details{
The functions is written in C++ in order to be as fast as possible.
}

\value{
A vector with the column medians.
}

%\references{
%Tsagris M.T., Preston S. and Wood A.T.A. (2011). A data-based power transformation for compositional data. In Proceedings of the 4th Compositional Data Analysis Workshop, Girona, Spain.
%}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris <mtsagris@yahoo.gr> and Manos Papadakis <papadakm95@gmail.com>.
}


\seealso{
\code{\link{colVars}, \link{colMeans} (buit-in R function)
}
}

\examples{
x <- matrix( rnorm(100 * 1000), ncol = 1000 )
system.time( apply(x, 2, median) )
system.time( colMedians(x) )
system.time( colMedians_parallel(x, ncores = 2) )
a <- apply(x, 2, median) 
b1 <- colMedians(x) 
b2 <- colMedians_parallel(x, ncores = 2)
all.equal(a, b1)
all.equal(a, b2)
}

\keyword{ Column-wise medians }
\keyword{ parallel computations }

