% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_navigation.R
\name{mod_navigation}
\alias{mod_navigation}
\alias{navigation_message}
\alias{all_patient_search_dt}
\alias{chart_review_subject_info}
\alias{chart_review_navigation}
\alias{navigation_server}
\title{Patient Navigation Module}
\usage{
navigation_message(id)

all_patient_search_dt(id)

chart_review_subject_info(id)

chart_review_navigation(id)

navigation_server(
  id,
  database_vars,
  data_model_vars,
  abstract_vars,
  parent_session
)
}
\arguments{
\item{id}{The Module namespace}

\item{database_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_database_setup}.}

\item{data_model_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_data_model_detection}.}

\item{abstract_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_abstraction_setup}.}

\item{parent_session}{The session information from the parent environment of this module.}
}
\value{
\emph{navigation_message}:
\item{tagList}{A uiOutput to display a placeholder message when no
database is connected.}
\emph{all_patient_search_dt}:
\item{tagList}{A uiOutput containing the "all patients" dataTable
with patient demographic information from the connected database.}
\emph{chart_review_subject_info}:
\item{tagList}{A uiOutput containing the selected subject's
demographic information to display on the 'Chart Review' tab.}
\emph{chart_review_navigation}:
\item{tagList}{A uiOutput containing the "Jump to Subject ID'
dropdown and previous and next buttons used to navigate through patient data on the
'Chart Review' tab.}
\emph{navigation_server}:
\item{reactiveValues}{
\itemize{
\item{\emph{selected_subject_id}}: A character representing the currently selected subject in
the currently connected database.
\item{\emph{selected_subject_info}}: A \link[dplyr:reexports]{dplyr::tibble} containing demographic information about
the selected subject.
\item{\emph{selected_subject_status}}: A character containing the abstraction status of the
selected subject, when an abstraction module is configured and abstraction data is
present.
}}
}
\description{
This module will render the "all patients" dataTable (DT) located on the 'Patient Search'
tab of ReviewR and will display demographic information about subjects in the
connected database. The subject id of the selections made on this tab are extracted and
passed to other ReviewR modules. As selections are made using the DT or the navigation
buttons on the 'Chart Review' tab, the selected patient in the DT is kept in sync by
this module.

Additionally, demographic and (optionally) abstraction status information about the
selected patient are extracted and placed into a header on the 'Chart Review' tab.

This module consists of the following components:
\subsection{Module UI functions}{

\itemize{
\item{\code{navigation_message}}: A uiOutput to display a placeholder message when no
database is connected.
\item{\code{all_patient_search_dt}}: A uiOutput containing the "all patients" dataTable
with patient demographic information from the connected database.
\item{\code{chart_review_subject_info}}: A uiOutput containing the selected subject's
demographic information to display on the 'Chart Review' tab.
\item{\code{chart_review_navigation}}: A uiOutput containing the "Jump to Subject ID'
dropdown and previous and next buttons used to navigate through patient data on the
'Chart Review' tab.
}
}

\subsection{Module Server function}{

\itemize{
\item{navigation_server}: Provides all of the logic associated with displaying
patient demographic information, selecting a patient to review, and navigating
through the connected patient database. Returns user selected patient information
for use by other modules.
}
}

\subsection{Keyboard Shortcuts}{

This module also provides keyboard shortcuts to assist with navigating through
patient data. The "meta" key refers to "ctrl" on Windows and "Cmd" on Mac.
\itemize{
\item Next Patient: “alt + meta + >”
\item Prev Patient: “alt + meta + <”
}
}
}
\keyword{internal}
