/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.relationships;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.relationships.AlteredParts;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Patcher {
    private static Logger log = LoggerFactory.getLogger(Patcher.class);

    public static void apply(WordprocessingMLPackage otherPackage, AlteredParts.Alterations alterations) throws Docx4JException, JAXBException {
        RelationshipsPart newRP;
        Part parentPart;
        if (alterations.getContentTypes() != null) {
            log.info("replacing [Content_Types].xml");
            ContentTypeManager newCTM = new ContentTypeManager();
            newCTM.parseContentTypesFile(new ByteArrayInputStream(alterations.getContentTypes()));
            otherPackage.setContentTypeManager(newCTM);
        }
        if (alterations.isEmpty()) {
            return;
        }
        ArrayList<PartName> removedParts = new ArrayList<PartName>();
        for (AlteredParts.Alteration a : alterations.getPartsDeleted()) {
            org.docx4j.xmlPackage.Part xmlpart = a.getPart();
            if (removedParts.contains(xmlpart.getName())) continue;
            parentPart = otherPackage.getParts().get(a.getSourcePartName());
            if (a.getPart().getContentType().equals("application/vnd.openxmlformats-package.relationships+xml")) {
                parentPart.setRelationships(null);
                continue;
            }
            removedParts.addAll(parentPart.getRelationshipsPart().removePart(new PartName(xmlpart.getName())));
        }
        for (AlteredParts.Alteration a : alterations.getPartsModified()) {
            log.info("Applying modifications to part: " + a.getPart().getName());
            if (a.getPart().getContentType().equals("application/vnd.openxmlformats-package.relationships+xml")) {
                newRP = FlatOpcXmlImporter.createRelationshipsPart(a.getPart());
                if (a.getSourcePartName().equals("/")) {
                    otherPackage.setRelationships(newRP);
                    newRP.setSourceP(otherPackage);
                    continue;
                }
                parentPart = otherPackage.getParts().get(a.getSourcePartName());
                parentPart.setRelationships(newRP);
                newRP.setSourceP(parentPart);
                continue;
            }
            Part targetPart = otherPackage.getParts().get(new PartName(a.getPart().getName()));
            if (targetPart == null) {
                log.error("Couldn't find " + a.getPart().getName() + " @ " + a.getSourcePartName().getName());
                continue;
            }
            Part tmpPart = FlatOpcXmlImporter.getRawPart(otherPackage.getContentTypeManager(), a.getPart(), null);
            if (targetPart instanceof JaxbXmlPart) {
                ((JaxbXmlPart)targetPart).setJaxbElement(((JaxbXmlPart)tmpPart).getJaxbElement());
                continue;
            }
            if (targetPart instanceof XmlPart) {
                ((XmlPart)targetPart).setDocument(((XmlPart)tmpPart).getDocument());
                continue;
            }
            if (targetPart instanceof CustomXmlDataStoragePart) {
                ((CustomXmlDataStoragePart)targetPart).setData(((CustomXmlDataStoragePart)tmpPart).getData());
                continue;
            }
            if (targetPart instanceof BinaryPart) {
                ((BinaryPart)targetPart).setBinaryData(((BinaryPart)tmpPart).getBuffer());
                continue;
            }
            log.error("TODO: handle " + targetPart.getClass().getName());
        }
        for (AlteredParts.Alteration a : alterations.getPartsAdded()) {
            log.info("Adding part: " + a.getPart().getName());
            if (a.getPart().getContentType().equals("application/vnd.openxmlformats-package.relationships+xml")) {
                newRP = FlatOpcXmlImporter.createRelationshipsPart(a.getPart());
                if (a.getSourcePartName().equals("/")) {
                    otherPackage.setRelationships(newRP);
                    newRP.setSourceP(otherPackage);
                    continue;
                }
                parentPart = otherPackage.getParts().get(a.getSourcePartName());
                parentPart.setRelationships(newRP);
                newRP.setSourceP(parentPart);
                continue;
            }
            Part parentPart2 = otherPackage.getParts().get(a.getSourcePartName());
            Part newPart = FlatOpcXmlImporter.getRawPart(otherPackage.getContentTypeManager(), a.getPart(), null);
            newPart.setOwningRelationshipPart(parentPart2.getRelationshipsPart());
            newPart.getSourceRelationships().add(parentPart2.getRelationshipsPart().getRel(new PartName(a.getPart().getName())));
            otherPackage.getParts().put(newPart);
            newPart.setPackage(otherPackage);
        }
    }
}

