/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.ConversionHTMLScriptElementHandler;
import org.docx4j.convert.out.ConversionHTMLStyleElementHandler;
import org.docx4j.fonts.Mapper;

public class HTMLSettings
extends AbstractConversionSettings {
    public static final String IMAGE_TARGET_URI = "imageTargetUri";
    public static final String CONDITIONAL_COMMENTS = "conditionalComments";
    public static final String FONT_FAMILY_STACK = "fontFamilyStack";
    public static final String STYLE_ELEMENT_HANDLER = "styleElementHandler";
    public static final String SCRIPT_ELEMENT_HANDLER = "scriptElementHandler";
    public static final String USER_CSS = "userCSS";
    public static final String USER_SCRIPT = "userScript";
    public static final String USER_BODY_TOP = "userBodyTop";
    public static final String USER_BODY_TAIL = "userBodyTail";

    public HTMLSettings() {
        this.settings.put(CONDITIONAL_COMMENTS, Boolean.FALSE);
        this.settings.put(FONT_FAMILY_STACK, Boolean.FALSE);
        this.settings.put(USER_CSS, "");
        this.settings.put(USER_SCRIPT, "");
        this.settings.put(USER_BODY_TOP, "<!-- userBodyTop goes here -->");
        this.settings.put(USER_BODY_TAIL, "<!-- userBodyTail goes here -->");
        this.addFeatures(DEFAULT_HTML_FEATURES);
    }

    public void setConditionalComments(Boolean conditionalComments) {
        this.settings.put(CONDITIONAL_COMMENTS, conditionalComments);
    }

    public void setFontFamilyStack(boolean val) {
        this.settings.put(FONT_FAMILY_STACK, new Boolean(val));
    }

    public void setFontMapper(Mapper fontMapper) {
        this.settings.put("fontMapper", fontMapper);
    }

    public Mapper getFontMapper() {
        return (Mapper)this.settings.get("fontMapper");
    }

    @Deprecated
    public String getUserCSS() {
        return (String)this.settings.get(USER_CSS);
    }

    @Deprecated
    public void setUserCSS(String val) {
        this.settings.put(USER_CSS, val);
    }

    @Deprecated
    public String getUserScript() {
        return (String)this.settings.get(USER_SCRIPT);
    }

    @Deprecated
    public void setUserScript(String val) {
        this.settings.put(USER_SCRIPT, val);
    }

    public String getUserBodyTop() {
        return (String)this.settings.get(USER_BODY_TOP);
    }

    public void setUserBodyTop(String val) {
        this.settings.put(USER_BODY_TOP, val);
    }

    public String getUserBodyTail() {
        return (String)this.settings.get(USER_BODY_TAIL);
    }

    public void setUserBodyTail(String val) {
        this.settings.put(USER_BODY_TAIL, val);
    }

    public void setImageTargetUri(String imageTargetUri) {
        this.settings.put(IMAGE_TARGET_URI, imageTargetUri);
    }

    public String getImageTargetUri() {
        return (String)this.settings.get(IMAGE_TARGET_URI);
    }

    public void setStyleElementHandler(ConversionHTMLStyleElementHandler styleElementHandler) {
        this.settings.put(STYLE_ELEMENT_HANDLER, styleElementHandler);
    }

    public ConversionHTMLStyleElementHandler getStyleElementHandler() {
        return (ConversionHTMLStyleElementHandler)this.settings.get(STYLE_ELEMENT_HANDLER);
    }

    public void setScriptElementHandler(ConversionHTMLScriptElementHandler scriptElementHandler) {
        this.settings.put(SCRIPT_ELEMENT_HANDLER, scriptElementHandler);
    }

    public ConversionHTMLScriptElementHandler getScriptElementHandler() {
        return (ConversionHTMLScriptElementHandler)this.settings.get(SCRIPT_ELEMENT_HANDLER);
    }
}

