/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.microsoft;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrosoftFontsRegistry {
    protected static Logger log = LoggerFactory.getLogger(MicrosoftFontsRegistry.class);
    private static HashMap<String, MicrosoftFonts.Font> msFontsByName;

    public static final Map<String, MicrosoftFonts.Font> getMsFonts() {
        return msFontsByName;
    }

    private static final void setupMicrosoftFontsRegistry() throws Exception {
        msFontsByName = new HashMap();
        JAXBContext msFontsContext = JAXBContext.newInstance((String)"org.docx4j.fonts.microsoft");
        Unmarshaller u = msFontsContext.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        log.info("unmarshalling fonts.microsoft");
        InputStream is = null;
        is = ResourceUtils.getResource("org/docx4j/fonts/microsoft/MicrosoftFonts.xml");
        MicrosoftFonts msFonts = (MicrosoftFonts)u.unmarshal(is);
        List<MicrosoftFonts.Font> msFontsList = msFonts.getFont();
        for (MicrosoftFonts.Font font : msFontsList) {
            msFontsByName.put(font.getName(), font);
        }
    }

    static {
        try {
            MicrosoftFontsRegistry.setupMicrosoftFontsRegistry();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

