/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlgraphics.fonts.Glyphs;
import org.docx4j.fonts.fop.fonts.SingleByteEncoding;

public class AbstractCodePointMapping
implements SingleByteEncoding {
    private String name;
    private char[] latin1Map;
    private char[] characters;
    private char[] codepoints;
    private char[] unicodeMap;
    private String[] charNameMap;
    private Map fallbackMap;

    public AbstractCodePointMapping(String name, int[] table) {
        this(name, table, null);
    }

    public AbstractCodePointMapping(String name, int[] table, String[] charNameMap) {
        this.name = name;
        this.buildFromTable(table);
        if (charNameMap != null) {
            this.charNameMap = new String[256];
            for (int i = 0; i < 256; ++i) {
                String charName = charNameMap[i];
                this.charNameMap[i] = charName == null ? ".notdef" : charName;
            }
        }
    }

    protected void buildFromTable(int[] table) {
        int nonLatin1 = 0;
        this.latin1Map = new char[256];
        this.unicodeMap = new char[256];
        Arrays.fill(this.unicodeMap, '\uffff');
        for (int i = 0; i < table.length; i += 2) {
            char unicode = (char)table[i + 1];
            if (unicode < '\u0100') {
                if (this.latin1Map[unicode] == '\u0000') {
                    this.latin1Map[unicode] = (char)table[i];
                }
            } else {
                ++nonLatin1;
            }
            if (this.unicodeMap[table[i]] != '\uffff') continue;
            this.unicodeMap[table[i]] = unicode;
        }
        this.characters = new char[nonLatin1];
        this.codepoints = new char[nonLatin1];
        int top = 0;
        block1: for (int i = 0; i < table.length; i += 2) {
            char c = (char)table[i + 1];
            if (c < '\u0100') continue;
            for (int j = ++top - 1; j >= 0; --j) {
                if (j <= 0 || this.characters[j - 1] < c) {
                    this.characters[j] = c;
                    this.codepoints[j] = (char)table[i];
                    continue block1;
                }
                this.characters[j] = this.characters[j - 1];
                this.codepoints[j] = this.codepoints[j - 1];
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final char mapChar(char c) {
        String[] alternatives;
        char latin1;
        if (c < '\u0100' && (latin1 = this.latin1Map[c]) > '\u0000') {
            return latin1;
        }
        int bot = 0;
        int top = this.characters.length - 1;
        while (top >= bot) {
            int mid = (bot + top) / 2;
            char mc = this.characters[mid];
            if (c == mc) {
                return this.codepoints[mid];
            }
            if (c < mc) {
                top = mid - 1;
                continue;
            }
            bot = mid + 1;
        }
        AbstractCodePointMapping mid = this;
        synchronized (mid) {
            Character fallback;
            if (this.fallbackMap != null && (fallback = (Character)this.fallbackMap.get(new Character(c))) != null) {
                return fallback.charValue();
            }
        }
        String glyphName = Glyphs.charToGlyphName((char)c);
        if (glyphName.length() > 0 && (alternatives = Glyphs.getCharNameAlternativesFor((String)glyphName)) != null) {
            int ic = alternatives.length;
            for (int i = 0; i < ic; ++i) {
                short idx = this.getCodePointForGlyph(alternatives[i]);
                if (idx < 0) continue;
                this.putFallbackCharacter(c, (char)idx);
                return (char)idx;
            }
        }
        this.putFallbackCharacter(c, '\u0000');
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFallbackCharacter(char c, char mapTo) {
        AbstractCodePointMapping abstractCodePointMapping = this;
        synchronized (abstractCodePointMapping) {
            if (this.fallbackMap == null) {
                this.fallbackMap = new HashMap();
            }
            this.fallbackMap.put(new Character(c), new Character(mapTo));
        }
    }

    public final char getUnicodeForIndex(int idx) {
        return this.unicodeMap[idx];
    }

    public final char[] getUnicodeCharMap() {
        char[] copy = new char[this.unicodeMap.length];
        System.arraycopy(this.unicodeMap, 0, copy, 0, this.unicodeMap.length);
        return copy;
    }

    public short getCodePointForGlyph(String charName) {
        String[] names = this.charNameMap;
        if (names == null) {
            names = this.getCharNameMap();
        }
        short c = (short)names.length;
        for (short i = 0; i < c; i = (short)(i + 1)) {
            if (!names[i].equals(charName)) continue;
            return i;
        }
        return -1;
    }

    public String[] getCharNameMap() {
        if (this.charNameMap != null) {
            String[] copy = new String[this.charNameMap.length];
            System.arraycopy(this.charNameMap, 0, copy, 0, this.charNameMap.length);
            return copy;
        }
        Object[] derived = new String[256];
        Arrays.fill(derived, ".notdef");
        for (int i = 0; i < 256; ++i) {
            String charName;
            char c = this.getUnicodeForIndex(i);
            if (c == '\uffff' || (charName = Glyphs.charToGlyphName((char)c)).length() <= 0) continue;
            derived[i] = charName;
        }
        return derived;
    }

    public String toString() {
        return this.getName();
    }
}

