% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTablePublicAPI.R
\name{setZebraStyle}
\alias{setZebraStyle}
\title{FlexTable rows zebra striping}
\usage{
setZebraStyle(object, odd, even)
}
\arguments{
\item{object}{a \code{FlexTable} object}

\item{odd}{background color applied to odd row indexes - single character value (e.g. "#000000" or "black")}

\item{even}{background color applied to even row indexes - single character value (e.g. "#000000" or "black")}
}
\description{
applies background color to alternate rows (zebra striping).
Set a color if row index is odd and another if row index is even.
}
\examples{
\donttest{
MyFTable <- FlexTable( data = iris[1:10, ] )

# Zebra striped table
MyFTable <- setZebraStyle( MyFTable, odd = "#8A949B", even = "#FAFAFA" )
}
}
\seealso{
\code{\link{FlexTable}}
}

