% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FlexRow.R
\name{FlexRow}
\alias{FlexRow}
\title{Row object for FlexTable}
\usage{
FlexRow(values, colspan, text.properties = textProperties(),
  par.properties = parProperties(), cell.properties = cellProperties())
}
\arguments{
\item{values}{Optional. a character vector to use as text content, the row will contain as many cells as there are in \code{values}.}

\item{colspan}{integer Optional. vector specifying for each element the number of columns to span for each corresponding value (in \code{values}).}

\item{text.properties}{Optional. textProperties to apply to each cell. Used only if values are not missing.}

\item{par.properties}{Optional. parProperties to apply to each cell. Used only if values are not missing.}

\item{cell.properties}{Optional. cellProperties to apply to each cell. Used only if values are not missing.}
}
\description{
Create a representation of a row that can be inserted in a FlexTable.
For internal usage.
}
\examples{
#
## example with characters
headerRow = FlexRow( c("Column 1", "Column 2")
  , cell.properties = cellProperties(background.color="#527578") )
## example with FlexCell
headerRow = FlexRow()
headerRow[1] = FlexCell( "Column 1"
  , cell.properties = cellProperties(background.color="#527578")  )
headerRow[2] = FlexCell( "Column 2"
  , cell.properties = cellProperties(background.color="#527578")  )
}
\seealso{
\code{\link{FlexTable}}, \code{\link{alterFlexRow}}
, \code{\link{addHeaderRow}}, \code{\link{addFooterRow}}
}

