/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.lysis.reporters.html4r.elements.Title;

public class Tree<T> {
    private T head;
    private ArrayList<Tree<T>> feuilles = new ArrayList();
    private Tree<T> parent = null;
    private HashMap<T, Tree<T>> locate = new HashMap();
    private static final int indent = 2;

    public Tree(T head) {
        this.head = head;
        this.locate.put(head, this);
    }

    public void addLeaf(T root, T leaf) {
        if (this.locate.containsKey(root)) {
            this.locate.get(root).addLeaf(leaf);
        } else {
            this.addLeaf(root).addLeaf(leaf);
        }
    }

    public Tree<T> addLeaf(T leaf) {
        Tree<T> t = new Tree<T>(leaf);
        this.feuilles.add(t);
        t.parent = this;
        t.locate = this.locate;
        this.locate.put(leaf, t);
        return t;
    }

    public Tree<T> setAsParent(T parentRoot) {
        Tree<T> t = new Tree<T>(parentRoot);
        t.feuilles.add(this);
        this.parent = t;
        t.locate = this.locate;
        t.locate.put(this.head, this);
        t.locate.put(parentRoot, t);
        return t;
    }

    public T getHead() {
        return this.head;
    }

    public Tree<T> getTree(T element) {
        return this.locate.get(element);
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Collection<T> getSuccessors(T root) {
        ArrayList<T> successors = new ArrayList<T>();
        Tree<T> tree = this.getTree(root);
        if (tree != null) {
            for (Tree<T> leaf : tree.feuilles) {
                successors.add(leaf.head);
            }
        }
        return successors;
    }

    public Collection<Tree<T>> getLeafs() {
        return this.feuilles;
    }

    public static <T> Collection<T> getSuccessors(T of, Collection<Tree<T>> in) {
        for (Tree<T> tree : in) {
            if (!tree.locate.containsKey(of)) continue;
            return tree.getSuccessors(of);
        }
        return new ArrayList();
    }

    public String toString() {
        return this.printTree(0);
    }

    private String printTree(int increment) {
        String s = "";
        String inc = "";
        int i = 0;
        while (i < increment) {
            inc = String.valueOf(inc) + " ";
            ++i;
        }
        s = String.valueOf(inc) + this.head;
        for (Tree<T> child : this.feuilles) {
            s = String.valueOf(s) + "\n" + super.printTree(increment + 2);
        }
        return s;
    }

    public String Tree2HTML() {
        String out = "<ul class=\"nav bs-docs-sidenav\">";
        int lev = 0;
        if (this.feuilles.size() > 0) {
            for (Tree<T> child : this.feuilles) {
                out = String.valueOf(out) + child.render2HTML(lev);
            }
        }
        out = String.valueOf(out) + "</ul>";
        return out;
    }

    public String render2HTML(int level) {
        String out = "";
        Title temp = (Title)this.head;
        ++level;
        if (this.feuilles.size() < 1) {
            out = String.valueOf(out) + "<li>";
            out = String.valueOf(out) + "<a href=\"#" + temp.getUID() + "\">";
            out = String.valueOf(out) + temp.getValue();
            out = String.valueOf(out) + "</a>";
            out = String.valueOf(out) + "</li>";
        } else {
            out = String.valueOf(out) + "<li>";
            out = String.valueOf(out) + "<a href=\"#" + temp.getUID() + "\">";
            out = String.valueOf(out) + temp.getValue();
            out = String.valueOf(out) + "</a>";
            out = String.valueOf(out) + "<ul class=\"nav nav-list\">";
            for (Tree<T> child : this.feuilles) {
                out = String.valueOf(out) + child.render2HTML(level);
            }
            out = String.valueOf(out) + "</ul>";
            out = String.valueOf(out) + "</li>";
        }
        return out;
    }
}

