/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.html4r.elements;

import java.util.LinkedHashMap;

import org.lysis.reporters.html4r.tools.Tree;
import org.lysis.reporters.tools.HTML4R;


public class TOC implements HTML4R{
	private LinkedHashMap<Integer, Title> titles;
	private int titleIndex;
	private Tree<Title> tree;
	private Title currentContainer;
	private int currentLevel;
	
	
	public TOC(String headStr){
		titles = new LinkedHashMap<Integer, Title>();
		titleIndex=-1;
		currentLevel = 0;
		Title root = new Title(headStr, 0);
		tree = new Tree<Title>(root);
		currentContainer = root;
	}
	
	public void addTitle(Title title){
		titleIndex++;
		titles.put(titleIndex, title);
		
		if( title.getLevel() > currentLevel ){
			tree.addLeaf(currentContainer, title);
		} else if( title.getLevel() == currentLevel ){
			tree.getTree(currentContainer).getParent().addLeaf(title);
		}else if( title.getLevel() < currentLevel ){
			tree.getTree(currentContainer).getParent().getParent().addLeaf(title);
		} else {
		}
		currentContainer = title; 
		currentLevel = title.getLevel();
	}
  
	@Override
	public String getHTML() {
		String out = "<div class=\"bs-docs-sidebar hidden-print hidden-xs hidden-sm\" role=\"complementary\">"
			    + tree.Tree2HTML()
			    + "<a class=\"back-to-top\" href=\"#top\">"
			      + "Back to top"
			    + "</a>"
			  + "</div>";
		return out;
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}
	
	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}


}
