package org.lysis.reporters.html4r.elements.menu;

import java.util.LinkedList;

import org.lysis.reporters.tools.HTML4R;

public class BootstrapMenu implements HTML4R{
	private String title;
	private String linkurl;
	private LinkedList<HTML4R> items;
	String col_bg_active_color;
	String col_bg_color;
	String col_text_emp_color;
	String col_text_color;
	
	public BootstrapMenu( String title, String link, String bg_active_color,
			String bg_color, String text_emp_color, String text_color){
		this.title = title;
		this.linkurl = link;
		items = new LinkedList<HTML4R>();
		col_bg_active_color = bg_active_color;
		col_bg_color = bg_color;
		col_text_emp_color = text_emp_color;
		col_text_color = text_color;
	}
	
	public void add( String label, String link, boolean active ){
		MenuLink l = new MenuLink(label, link);
		if( active ) l.setActive();
		items.add(l);
	}

	public void add( Dropdown d){
		items.add(d);
	}
	
	@Override
	public String getHTML() {
		
		String out = "<header class=\"navbar navbar-static-top bs-docs-nav navbar-default\" id=\"top\" role=\"banner\">"
				  + "<div class=\"container\">"
				    + "<div class=\"navbar-header\">"
				      + "<button class=\"navbar-toggle\" type=\"button\" data-toggle=\"collapse\" data-target=\".bs-navbar-collapse\">"
				        + "<span class=\"sr-only\">Toggle navigation</span>"
				        + "<span class=\"icon-bar\"></span>"
				        + "<span class=\"icon-bar\"></span>"
				        + "<span class=\"icon-bar\"></span>"
				      + "</button>"
				      + "<a href=\""+ linkurl +"\" class=\"navbar-brand\">" + title + "</a>"
				    + "</div>"
				    + "<nav class=\"collapse navbar-collapse bs-navbar-collapse\" role=\"navigation\">"
				      + "<ul class=\"nav navbar-nav\">";
		for( int i = 0 ; i < items.size() ; i++ ){
			out += items.get(i).getHTML();
		}
		out += "</ul>"
				      + "</nav>"
				    + "</div>"
				  + "</header>";

		return out;
	}
	
	@Override
	public String getCSS() {
		String val = ".navbar-default {"
				+"  background-color: " + col_bg_color + ";"
				+"  border-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-brand {"
				+"  color: " + col_text_color + ";"
				+"}"
				+".navbar-default .navbar-brand:hover, .navbar-default .navbar-brand:focus {"
				+"  color: " + col_text_emp_color + ";"
				+"}"
				+".navbar-default .navbar-text {"
				+"  color: " + col_text_color + ";"
				+"}"
				+".navbar-default .navbar-nav > li > a {"
				+"  color: " + col_text_color + ";"
				+"}"
				+".navbar-default .navbar-nav > li > a:hover, .navbar-default .navbar-nav > li > a:focus {"
				+"  color: " + col_text_emp_color + ";"
				+"  background-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-nav > .active > a, .navbar-default .navbar-nav > .active > a:hover, .navbar-default .navbar-nav > .active > a:focus {"
				+"  color: " + col_text_emp_color + ";"
				+"  background-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus {"
				+"  color: " + col_text_emp_color + ";"
				+"  background-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-toggle {"
				+"  border-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-toggle:hover, .navbar-default .navbar-toggle:focus {"
				+"  background-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-toggle .icon-bar {"
				+"  background-color: " + col_bg_active_color + ";"
				+"}"
				+".navbar-default .navbar-collapse,"
				+".navbar-default .navbar-form {"
				+"  border-color: " + col_text_color + ";"
				+"}"
				+".navbar-default .navbar-link {"
				+"  color: " + col_text_color + ";"
				+"}"
				+".navbar-default .navbar-link:hover {"
				+"  color: " + col_text_emp_color + ";"
				+"}"
				+""
				+"@media (max-width: 767px) {"
				+"  .navbar-default .navbar-nav .open .dropdown-menu > li > a {"
				+"    color: " + col_text_color + ";"
				+"  }"
				+"  .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover, .navbar-default .navbar-nav .open .dropdown-menu > li > a:focus {"
				+"    color: " + col_text_emp_color + ";"
				+"  }"
				+"  .navbar-default .navbar-nav .open .dropdown-menu > .active > a, .navbar-default .navbar-nav .open .dropdown-menu > .active > a:hover, .navbar-default .navbar-nav .open .dropdown-menu > .active > a:focus {"
				+"    color: " + col_text_emp_color + ";"
				+"    background-color: " + col_bg_active_color + ";"
				+"  }"
				+"}"
				+""
				+""
				+".dropdown-menu > .active > a,"
				+".dropdown-menu > .active > a:hover,"
				+".dropdown-menu > .active > a:focus {"
				+"  color: " + col_text_emp_color + ";"
				+"  text-decoration: none;"
				+"  background-color: " + col_bg_active_color + ";"
				+"  outline: 0;"
				+"}"
				+""
				+".dropdown-menu > li > a,"
				+".dropdown-menu > li > a:hover,"
				+".dropdown-menu > li > a:focus {"
				+"  color: " + col_bg_active_color + ";"
				+"  background-color: " + col_text_emp_color + ";"
				+"}"
				+".dropdown-menu > li > a:hover,"
				+".dropdown-menu > li > a:focus {"
				+"  text-decoration: none;"
				+"  background-color: " + col_bg_active_color + ";"
				+"  color: " + col_text_emp_color + ";"
				+"}" ;
		return val;
	}
	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return true;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}


}
