/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.docx4j.dml.CTTableCell;
import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.lysis.reporters.formats.BorderProperties;
import org.lysis.reporters.formats.CellProperties;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;

public class FlexCell
extends DocComponent
implements HTML4R,
Cloneable {
    private ParagraphSet section;
    private CellProperties cellProproperties;
    private int colspan;
    private int rowspan;

    public FlexCell(ParagraphSet p, CellProperties cp) {
        this.setParagraphsSection(p);
        this.setCellProperties(cp);
        this.colspan = 1;
        this.rowspan = 1;
    }

    public CellProperties getCellProperties() {
        return this.cellProproperties;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int value) {
        this.colspan = value;
    }

    public ParagraphSet getParagraphsSection() {
        return this.section;
    }

    public void setParagraphsSection(ParagraphSet p) {
        this.section = p;
    }

    @Override
    public void setParProperties(ParProperties pp) {
        this.section.setParProperties(pp);
    }

    public void setTextProperties(TextProperties tp) {
        this.section.setTextProperties(tp);
    }

    public void setCellProperties(CellProperties cp) {
        this.cellProproperties = cp;
    }

    public void setBorderBottom(BorderProperties bp) {
        this.cellProproperties.setBorderBottom(bp);
    }

    public void setBorderTop(BorderProperties bp) {
        this.cellProproperties.setBorderTop(bp);
    }

    public void setBorderLeft(BorderProperties bp) {
        this.cellProproperties.setBorderLeft(bp);
    }

    public void setBorderRight(BorderProperties bp) {
        this.cellProproperties.setBorderRight(bp);
    }

    public void setRowspan(int value) {
        this.rowspan = value;
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + this.section.toString();
        return out;
    }

    @Override
    public String getHTML() {
        if (this.rowspan < 1) {
            return "";
        }
        if (this.colspan < 1) {
            return "";
        }
        LinkedHashMap<String, String> cpr = this.cellProproperties.get_html_cp();
        String out = "<td style=\"" + Format.getJSString(cpr) + "\"";
        if (this.colspan > 1) {
            out = String.valueOf(out) + " colspan=\"" + this.colspan + "\"";
        }
        if (this.rowspan > 1) {
            out = String.valueOf(out) + " rowspan=\"" + this.rowspan + "\"";
        }
        out = String.valueOf(out) + ">";
        this.section.setHTMLReference(this.list_id, this.counters, this.numbDefinition);
        out = String.valueOf(out) + this.section.getHTML();
        out = String.valueOf(out) + "</td>";
        return out;
    }

    public Tc getTc() throws Exception {
        TcPrInner.VMerge merge;
        Tc tc = new Tc();
        this.section.setNumberingDefinitionsPart(this.ndp);
        this.section.setOrderedNumID(this.ordered_num_id);
        this.section.setUnorderedNumID(this.unordered_num_id);
        this.section.setDOCXMLPackage(this.getDOCXMLPackage());
        tc.getContent().addAll(this.section.get_docx_elt());
        TcPr tcPr = this.cellProproperties.get_docx_cp();
        if (this.colspan > 1) {
            TcPrInner.GridSpan gridSpan = new TcPrInner.GridSpan();
            gridSpan.setVal(BigInteger.valueOf(this.colspan));
            tcPr.setGridSpan(gridSpan);
        }
        if (this.rowspan > 1) {
            merge = new TcPrInner.VMerge();
            merge.setVal("restart");
            tcPr.setVMerge(merge);
        } else if (this.rowspan < 1) {
            merge = new TcPrInner.VMerge();
            merge.setVal("continue");
            tcPr.setVMerge(merge);
        }
        tc.setTcPr(tcPr);
        return tc;
    }

    public CTTableCell getCTTableCell() throws Exception {
        CTTableCell tc = new CTTableCell();
        tc.setTxBody(this.section.get_pptx_parset());
        CTTableCellProperties tcPr = this.cellProproperties.get_pptx_cp();
        if (this.colspan > 1) {
            tc.setGridSpan(Integer.valueOf(this.colspan));
        } else if (this.colspan < 1) {
            tc = new CTTableCell();
            tc.setHMerge(Boolean.valueOf(true));
            CTTableCellProperties temp = new CTTableCellProperties();
            temp.setNoFill(tcPr.getNoFill());
            tc.setTcPr(temp);
            return tc;
        }
        if (this.rowspan > 1) {
            tc.setRowSpan(Integer.valueOf(this.rowspan));
        } else if (this.rowspan < 1) {
            tc.setVMerge(Boolean.valueOf(true));
        }
        if (this.colspan > 0) {
            tc.setTcPr(tcPr);
        }
        return tc;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    public FlexCell clone() {
        FlexCell fc = new FlexCell(this.section, this.cellProproperties);
        return fc;
    }

    public int getRowspan() {
        return this.rowspan;
    }
}

