# ReplicationSuccess

Provides utilities for the design and analysis of replication studies.
Features both traditional methods based on statistical significance and
more recent methods such as the sceptical p-value. Also provides related
methods including the harmonic mean chi-squared test and intrinsic credibility.
Contains datasets from four large-scale replication projects.

## Installation

CRAN version:
```r
install.packages("ReplicationSuccess")
```

Development version from github:
```r
devtools::install_github(repo = "florafauna/ReplicationSuccess")
```

## Introduction in vignette

To access the vignette from R use:
```r
library("ReplicationSuccess")
vignette("ReplicationSuccess")
```


## Publications

  - Held, L. (2020). A new standard for the analysis and design of replication
  studies (with discussion). *Journal of the Royal Statistical Society: Series A
  (Statistics in Society)*. 183(2):431-448. <https://doi.org/10.1111/rssa.12493>
  
  - Held, L., Micheloud, C., Pawel, S. (2021). The assessment of replication
  success based on relative effect size. <https://arxiv.org/abs/2009.07782>
  
  - Held, L. (2020). The harmonic mean chi-squared test to substantiate
    scientific findings. *Journal of the Royal Statistical Society: Series C
    (Applied Statistics)*, 69:697-708. <https://doi.org/10.1111/rssc.12410>
    
  - Micheloud, C., Held, L. (2021). Power Calculations for Replication Studies.
    <https://arxiv.org/abs/2004.10814>
    
  - Pawel, S., Held, L. (2020). Probabilistic forecasting of replication
    studies. PLoS ONE 15(4):e0231416.
    <https://doi.org/10.1371/journal.pone.0231416>
    
  - Held, L. (2019). The assessment of intrinsic credibility and a new argument
    for *p* < 0.005. *Royal Society Open Science*, 6:181534.
    <https://dx.doi.org/10.1098/rsos.181534>
