% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/preFitModel.R
\name{preFitModel}
\alias{preFitModel}
\title{Fits a linear mixed model (without fixed SNP effects) and computes the fitted variance-covariance matrix for later use in the rGLS function.}
\usage{
preFitModel(fixed = y ~ 1, random = ~1 | id, id.name = "id", genabel.data,
  phenotype.data, corStruc = NULL, GRM = NULL, Neighbor.Matrix = NULL)
}
\arguments{
\item{fixed}{A formula including the response and fixed effects}

\item{random}{A formula for the random effects}

\item{id.name}{The column name of the IDs in phen.data}

\item{genabel.data}{An GenABEL object including marker information. This object has one observation per individual.}

\item{phenotype.data}{A data frame including the repeated observations and IDs.}

\item{corStruc}{A list specifying the correlation structure for each random effect. The options are: \code{"Ind"} for iid random effects, \code{"GRM"} for a correlation structure given by a genetic relationship matrix, or \code{"CAR"} for a spatial correlation structure given by a Conditional Autoregressive model specified by a neighborhood matrix.}

\item{GRM}{A genetic relationship matrix. If not specified whilst the \code{"GRM"} option is given for \code{corStruc} then the GRM is computed internally within the function.}

\item{Neighbor.Matrix}{A neighborhood matrix having non-zero value for an element (i,j) where the observations i and j come from neighboring locations. The diagonal elements should be zero.}
}
\value{
Returns a list including the fitted hglm object \code{fitted.hglm}, the variance-covariance matrix \code{V} and the ratios between estimated variance components for the random effects divided by the residual variance, \code{ratio}.
}
\description{
Uses a GenABEL object and phenotype data as input. The model is fitted using the \code{hglm} function in the hglm package.
}
\examples{
  \donttest{
####### FIRST EXAMPLE USING GRM #############
 data(Phen.Data) #Phenotype data with repeated observations
 data(gen.data) #GenABEL object including IDs and marker genotypes
 GWAS1 <- rGLS(y ~ age + sex, genabel.data = gen.data, phenotype.data = Phen.Data)
 plot(GWAS1, main="")
 summary(GWAS1)
 #Summary for variance component estimation without SNP effects
 summary(GWAS1@call$hglm)
 #The same results can be computed using the preFitModel as follows
 fixed = y ~ age + sex
 Mod1 <- preFitModel(fixed, random=~1|id, genabel.data = gen.data,
                     phenotype.data = Phen.Data, corStruc=list( id=list("GRM","Ind") ))
 GWAS1b <- rGLS(fixed, genabel.data = gen.data,
                phenotype.data = Phen.Data, V = Mod1$V)
 plot(GWAS1b, main="Results using the preFitModel function")
 ####### SECOND EXAMPLE USING CAR #############
 # Add a fake nest variable to the data just to run the example
 #In this example there are 6 nests and 60 observations per nest
 Phen.Data$nest <- rep(1:6, each=60)
 #A model including polygenic effects, permanent environmental effects,
 #and nest effect as random
 Mod2 <- preFitModel(fixed, random=~1|id + 1|nest, genabel.data = gen.data,
          phenotype.data = Phen.Data, corStruc=list( id=list("GRM","Ind"), nest=list("Ind")) )
 GWAS2 <- rGLS(fixed, genabel.data = gen.data, phenotype.data = Phen.Data, V = Mod2$V)
 plot(GWAS2)
 #Similar to previous plot because the nest effect variance component is almost 0.
 ###################
 #Construct a fake nighbourhood matrix
 D = matrix(0,6,6)
 D[1,2] = D[2,1] = 1
 D[5,6] = D[6,5] = 1
 D[2,4] = D[4,2] = 1
 D[3,5] = D[5,3] = 1
 D[1,6] = D[6,1] = 1
 D[3,4] = D[4,3] = 1
 #The matrix shows which pair of nests that can be considered as neighbours
 image(Matrix(D), main="Neighbourhood matrix")
 Mod3 <- preFitModel(fixed, random=~1|id + 1|nest, genabel.data = gen.data,
          phenotype.data = Phen.Data, corStruc=list( id=list("GRM","Ind"),
                                     nest=list("CAR")), Neighbor.Matrix=D )
 GWAS2b <- rGLS(fixed, genabel.data = gen.data,
                phenotype.data = Phen.Data, V = Mod3$V)
 plot(GWAS2b)
 }
}
\author{
Lars Ronnegard
}

