% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelimpPCR_Predict.R
\name{RelimpPCR.predict}
\alias{RelimpPCR.predict}
\title{Predictor Function for RelimpPCR}
\usage{
RelimpPCR.predict(pcr, newdata)
}
\arguments{
\item{pcr}{(pcr_object): The trained RelimpPCR object produced by the RelimpPCR() function.}

\item{newdata}{(data frame): The new X value(s) you wish to draw a prediction from.}
}
\value{
pred (data frame): A data frame containing the preictions.
}
\description{
This function takes the trained RelimpPCR object and proceeds to perform a prediction from the best model (as defined in the documentation of RelimpPCR()).
}
\examples{
\donttest{
#The below function takes a trained PCR object (produced by RelimpPCR) 
#and a dataframe (using the same columns that the PCR object was trained 
#with) and produces a prediction.
y = mtcars$mpg[1:20]; x = mtcars[1:20,c("cyl","disp")]
pcr_object = RelimpPCR(Y = y, X = x,target_r2 = 0.75, multicore = FALSE,
                       remove_factors = FALSE, normalize_data = FALSE, plot_this = FALSE)
pred = RelimpPCR.predict(pcr_object, data.frame(mtcars$cyl, mtcars$disp))
}
}
