\name{mvf.ver.quad}
\alias{mvf.ver.quad}

\title{Mean value function in the quadratic form for the Littlewood-Verall model}

\description{
\code{mvf.ver.quad} returns mean value function in the quadratic form for the 
Littlewood-Verall model.
}

\usage{
mvf.ver.quad(theta0, theta1, rho, t)
}

\arguments{
  \item{theta0}{parameter value for \code{theta0}}
  \item{theta1}{parameter value for \code{theta1}}
  \item{rho}{parameter value for \code{rho}}
  \item{t}{time between failure data}
}

\details{
This function gives the values of the mean value function in the quadratic form for
the Littlewood-Verall model, this is written as
\deqn{\mu(t) = 3 v_1 (Q_1 + Q_2),}
where
\deqn{v_1 = \frac{(\rho - 1)^{1 / 3}}{(18 \theta_1)^{1 / 3}},} 
\deqn{v_2 = \frac{4 \theta_0^3}{9 (\rho - 1)^2 \theta_1},}
\deqn{Q_1 = [t + (t^2 + v_2)^{1 / 2}]^{1 / 3}}
and
\deqn{Q_2 = [t - (t^2 + v_2)^{1 / 2}]^{1 / 3}.}
Further there is a verifying if the parameter \code{theta1} 
satisfy the assumptions for the Littlewood-Verall model. So the paramter \code{theta1} should 
net be equal zero, in equation \eqn{\theta_1 \neq 0.}
}

\value{
The mean value function in the quadratic form for the Littlewood-Verall model.
}

\references{
J.D. Musa, A. Iannino, and K. Okumoto. \emph{Software Reliability: Measurement,
Prediction, Application}. McGraw-Hill, 1987.

Michael R. Lyu. \emph{Handbook of Software Realibility Engineering}. IEEE Computer
Society Press, 1996.
\url{http://www.cse.cuhk.edu.hk/~lyu/book/reliability/}
}

\author{Andreas Wittmann \email{andreas\_wittmann@gmx.de}}

\seealso{\code{\link{littlewood.verall}}, \code{\link{littlewood.verall.plot}}, 
         \code{\link{mvf.ver.lin}}}

\examples{
# time between-failure-data from DACS Software Reliability Dataset
# homepage, see system code 1. Number of failures is 136.
t <- c(3, 30, 113, 81, 115, 9, 2, 20, 20, 15, 138, 50, 77, 24,
       108, 88, 670, 120, 26, 114, 325, 55, 242, 68, 422, 180,
       10, 1146, 600, 15, 36, 4, 0, 8, 227, 65, 176, 58, 457,
       300, 97, 263, 452, 255, 197, 193, 6, 79, 816, 1351, 148,
       21, 233, 134, 357, 193, 236, 31, 369, 748, 0, 232, 330,
       365, 1222, 543, 10, 16, 529, 379, 44, 129, 810, 290, 300,
       529, 281, 160, 828, 1011, 445, 296, 1755, 1064, 1783, 
       860, 983, 707, 33, 868, 724, 2323, 2930, 1461, 843, 12,
       261, 1800, 865, 1435, 30, 143, 108, 0, 3110, 1247, 943,
       700, 875, 245, 729, 1897, 447, 386, 446, 122, 990, 948,
       1082, 22, 75, 482, 5509, 100, 10, 1071, 371, 790, 6150,
       3321, 1045, 648, 5485, 1160, 1864, 4116)

lit.par1 <- littlewood.verall(t, linear = TRUE)$theta0
lit.par2 <- littlewood.verall(t, linear = TRUE)$theta1
lit.par3 <- littlewood.verall(t, linear = TRUE)$rho

mvf.ver.quad(lit.par1, lit.par2, lit.par3, t)
}

\keyword{models}
