## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(ReliaGrowR)

## -----------------------------------------------------------------------------
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)

## -----------------------------------------------------------------------------
result <- rga(times, failures)
plot_rga(result)

## -----------------------------------------------------------------------------
times <- c(100, 200, 300, 400, 500, 600, 700, 800, 900, 1000)
failures <- c(1, 2, 1, 1, 1, 2, 3, 1, 2, 4)
breakpoints <- 400

## -----------------------------------------------------------------------------
result <- rga(times, failures, model_type = "Piecewise Weibull NHPP", breakpoints = breakpoints)
plot_rga(result)

## -----------------------------------------------------------------------------
times <- c(100, 200, 300, 400, 500, 600, 700, 800, 900, 1000)
failures <- c(1, 2, 1, 1, 1, 2, 3, 1, 2, 4)

## -----------------------------------------------------------------------------
result <- rga(times, failures, model_type = "Piecewise Weibull NHPP")
plot_rga(result)

## -----------------------------------------------------------------------------
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)

## -----------------------------------------------------------------------------
fit <- duane_plot(times, failures)

