% Generated by roxygen2 (4.0.1): do not edit by hand
\name{as.BibEntry}
\alias{as.BibEntry}
\alias{is.BibEntry}
\title{Coerce to a BibEntry object}
\usage{
as.BibEntry(x)

is.BibEntry(x)
}
\arguments{
\item{x}{any \code{R} object.}
}
\value{
\code{as.BibEntry} - if successful, an object of class BibEntry.

\code{is.BibEntry} - logical; \code{TRUE} if \code{x} is a BibEntry object.
}
\description{
Functions to check if an object is a BibEntry, or coerce it if possible.
}
\details{
\code{as.BibEntry} is able to coerce suitably formatted character vectors, \code{\link{bibentry}} objects, lists,
and data.frames to BibEntry objects.  See the examples.
}
\note{
Each entry to be coerced should have a bibtype, key, and all required fields for the specified bibtype.
}
\examples{
file.name <- system.file("Bib", "biblatexExamples.bib", package="RefManageR")
bib <- suppressMessages(ReadBib(file.name))[[20:21]]
identical(as.BibEntry(unlist(bib)), bib)  ## see also RelistBibEntry

identical(as.BibEntry(unclass(bib)), bib)

identical(as.BibEntry(as.data.frame(bib)), bib)

bib <- c(bibtype = "article", key = "mclean2014", title = "My New Article",
  author = "Mathew W. McLean", journaltitle = "The Journal", date = "2014-01")
as.BibEntry(bib)

bib <- bibentry(bibtype = "article", key = "mclean2014", title = "My New Article",
journal = "The Journal", year = 2014, author = "Mathew W. McLean")
print(bib, .bibstyle = "JSS")
as.BibEntry(bib)

bib <- list(c(bibtype = "article", key = "mclean2014a", title = "My New Article",
  author = "Mathew W. McLean", journaltitle = "The Journal", date = "2014-01"),
  c(bibtype = "article", key = "mclean2014b", title = "Newer Article",
  author = "Mathew W. McLean", journaltitle = "The Journal", date = "2014-02"))
as.BibEntry(bib)
}
\seealso{
\code{\link{BibEntry}}
}
\keyword{utilities}

