% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.chisq.test.R
\name{p.chisq.test}
\alias{p.chisq.test}
\title{Pearson's Chi-Square Test for Probabilities of Record}
\usage{
p.chisq.test(
  X,
  record = c("upper", "lower"),
  simulate.p.value = FALSE,
  B = 1000
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}

\item{simulate.p.value}{Logical. Indicates whether to compute p-values by
Monte Carlo simulation. It is recommended if the function returns a 
warning (see Details).}

\item{B}{If \code{simulate.p.value = TRUE}, an integer specifying the 
number of replicates used in the Monte Carlo estimation.}
}
\value{
A \code{"htest"} object  with elements:
  \item{statistic}{Value of the chi-squared statistic.}
  \item{df}{Degrees of freedom.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs a chi-square goodness-of-fit test
  based on the record probabiliteis \eqn{p_t} to study the hypothesis
  of the classical record model (i.e., of IID continuous RVs).
}
\details{
The null hypothesis of this chi-square test is that in every vector 
  (columns of the matrix \code{X}), the probability of record at 
  time \eqn{t} is \eqn{1/t} as in the classical record model, 
  and the alternative that the probabilities are not equal to those values. 
  First, the chi-square goodness-of-fit statistics to study the  null 
  hypothesis \eqn{H_0:\,p_t = 1/t} are calculated for each time 
  \eqn{t=2,\ldots,T}, where the observed value is the number of records at 
  time \eqn{t} in the \eqn{M} vectors and the expected value under the null
  is \eqn{M / t}. The test statistic is the sum of the previous \eqn{T-1} 
  statistics and its distribution under the null 
  is approximately \eqn{\chi^2_{T-1}}.

  The chi-square approximation may not be valid with low \eqn{M}, since it
  requires expected values \eqn{> 5} or up to \eqn{20\%} of the expected 
  values are between 1 and 5. If this condition is not satisfied, a warning 
  is displayed. In order to avoid this problem, a \code{simulate.p.value}
  can be made by means of Monte Carlo simulations.
}
\examples{
# Warning, M = 76 small for the value of T = 70
p.chisq.test(ZaragozaSeries)
# Simulate p-value
p.chisq.test(ZaragozaSeries, simulate.p.value = TRUE, B = 10000)

}
\references{
Benestad RE (2003). 
“How Often Can We Expect a Record Event?” 
\emph{Climate Research}, \strong{25}(1), 3–13.

Benestad RE (2004). 
“Record-Values, Nonstationarity Tests and Extreme Value Distributions.” 
\emph{Global and Planetary Change}, \strong{44}(1–4), 11–26.
}
\seealso{
\code{\link{global.test}}, \code{\link{score.test}},
  \code{\link{p.record}}, \code{\link{p.regression.test}}, 
  \code{\link{lr.test}}
}
\author{
Jorge Castillo-Mateo
}
