#' @name thrasherDetectionData
#' 
#' @title Sage Thrasher detection data 
#' 
#' @description  
#' Point transect data collected in central Wyoming from 120 points
#' surveyed for Sage Thrashers by the Wyoming Cooperative Fish & Wildlife Research Unit in 2013.
#' See package vignettes for tutorials of the basic analysis. 
#' 
#' @docType data
#' 
#' @format A data.frame containing 193 rows and 3 columns.  Each row represents
#' a detected group of thrashers.  Column descriptions: 
#' \enumerate{ 
#'   \item \code{siteID}: Factor (120 levels), the site or point where the detection
#'   was made.  
#'   \item \code{groupsize}: Number, the number of individuals within
#'   the detected group.  
#'   \item \code{dist}: Number, the radial distance (m) from
#'   the transect to the detected group.  This is the distance used in analysis.
#' }
#' 
#' @seealso \code{\link{thrasherSiteData}}
#' 
#' @source The Sage Thrasher data are a subset of the data collected 
#' by Jason Carlisle and various field technicians for his Ph.D. from the 
#' Department of Ecology, University of Wyoming, in 2017.  This portion of 
#' Jason's work was funded by the Wyoming Game and Fish Department through agreements 
#' with the University of Wyoming's  Cooperative Fish & Wildlife
#' Research Unit (2012). 
#' 
#' @references Carlisle, J.D. 2017. The effect of sage-grouse conservation on
#' wildlife species of concern: implications for the umbrella species concept.
#' Dissertation. University of Wyoming, Laramie, Wyoming, USA.
#' 
#' Carlisle, J. D., A. D. Chalfoun, K. T. Smith, and J. L. Beck. 2018. 
#' Nontarget effects on songbirds from habitat manipulation for Greater 
#' Sage-Grouse: Implications for the umbrella species concept. 
#' \emph{The Condor: Ornithological Applications} 120:439–455. 
#' \doi{10.1650/CONDOR-17-200.1}
#' 
#' @keywords datasets
NULL