% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F.maximize.g.R
\name{F.maximize.g}
\alias{F.maximize.g}
\title{Find the coordinate of the maximum of a distance function}
\usage{
F.maximize.g(fit, covars = NULL)
}
\arguments{
\item{fit}{An estimated 'dfunc' object produced by \code{dfuncEstim}.}

\item{covars}{Covariate values to calculate maximum for.}
}
\value{
The value of x that maximizes g(x) in \code{fit}.
}
\description{
Find the x coordinate that maximizes g(x).
}
\examples{
\dontrun{
# Fake data
set.seed(22223333)
x <- rgamma(100, 10, 1)

fit <- dfuncEstim( x, likelihood="Gamma", x.scl="max" )

F.maximize.g( fit )  # should be near 10.
fit$x.scl            # same thing
}
}
\seealso{
\code{\link{dfuncEstim}}
}
\author{
Trent McDonald, WEST Inc.,  \email{tmcdonald@west-inc.com}
}
\keyword{model}
