% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LAPEIG.R
\name{do.lapeig}
\alias{do.lapeig}
\title{Laplacian Eigenmaps}
\usage{
do.lapeig(X, ndim = 2, type = c("proportion", 0.1), symmetric = "union",
  preprocess = "null", weighted = TRUE, kernelscale = 1)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null" and three options of "center", "decorrelate", or "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{weighted}{\code{TRUE} for weighted graph laplacian and \code{FALSE} for
combinatorial laplacian where connectivity is represented as 1 or 0 only.}

\item{kernelscale}{kernel scale parameter. Default value is 1.0.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{eigvals}{a vector of eigenvalues for laplacian matrix.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.lapeig} performs Laplacian Eigenmaps (LE) to discover low-dimensional
manifold embedded in high-dimensional data space using graph laplacians. This
is a classic algorithm employing spectral graph theory.
}
\examples{
## generate default dataset
X <- aux.gensamples()

## two types of graph laplacians using 20\% of neighbors
out1 <- do.lapeig(X,ndim=2,type=c("proportion",0.05),kernelscale=10) # weighted version
out2 <- do.lapeig(X,ndim=2,type=c("proportion",0.05),weighted=FALSE) # combinatorial

## Visualize
par(mfrow=c(1,2))
plot(out1$Y[,1],out1$Y[,2],main="weighted")
plot(out2$Y[,1],out2$Y[,2],main="combinatorial")

}
\references{
Belkin, M. and Niyogi, P. (2003) \emph{Laplacian Eigenmaps for Dimensionality Reduction and Data Representation}.
Neural Computation, 15 6:1373-1396.
}
\author{
Kisung You
}
