% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_webdriver.R
\name{run_browser}
\alias{run_browser}
\title{Start up web driver process on localhost, with a random port}
\usage{
run_browser(debugLevel = "DEBUG", timeout = 5000)
}
\arguments{
\item{debugLevel}{debug level, possible values: 'INFO', 'ERROR', 'WARN', 'DEBUG'}

\item{timeout}{How long to wait (in milliseconds) for the webdriver connection to be established to the phantomjs process.}
}
\value{
A list of \code{callr::process} object, and
  \code{port}, the local port where phantom is running.
}
\description{
Phantomjs is a headless browser, it provide automated control of a web page in
 an environment similar to web browsers, but via a command-line. It's able
 to render and understand HTML the same way a regular browser would, including
 styling elements such as page layout, colors, font selection and execution of
 JavaScript and AJAX which are usually not available when using GET request methods.
}
\details{
This function will throw an error if webdriver(phantomjs) cannot be found, or cannot be started.
 It works with a timeout of five seconds.

If you got the forllwing error, this means that your operating system or antivirus
 is bloking the webdriver (phantom.js) process, try to disable your antivirus temporarily or
 adjust your system configuration to allow phantomjs and processx executable (\link{browser_path}
 to know where phantomjs is located).
 Error in supervisor_start() :  processx supervisor was not ready after 5 seconds.
}
\examples{
\dontrun{

#If driver is not installed yet then
install_browser()

br<-run_browser()

}


}
