% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_webdriver.R
\name{install_browser}
\alias{install_browser}
\title{Install PhantomJS webdriver}
\usage{
install_browser(version = "2.1.1",
  baseURL = "https://github.com/wch/webshot/releases/download/v0.3.1/")
}
\arguments{
\item{version}{The version number of PhantomJS.}

\item{baseURL}{The base URL for the location of PhantomJS binaries for
download. If the default download site is unavailable, you may specify an
alternative mirror, such as
\code{"https://bitbucket.org/ariya/phantomjs/downloads/"}.}
}
\value{
\code{NULL} (the executable is written to a system directory).
}
\description{
Download the zip package, unzip it, and copy the executable to a system
directory in which \pkg{webdriver} can look for the PhantomJS executable.
}
\details{
This function was designed primarily to help Windows users since it is
cumbersome to modify the \code{PATH} variable. Mac OS X users may install
PhantomJS via Homebrew. If you download the package from the PhantomJS
website instead, please make sure the executable can be found via the
\code{PATH} variable.

On Windows, the directory specified by the environment variable
\code{APPDATA} is used to store \file{phantomjs.exe}. On OS X, the directory
\file{~/Library/Application Support} is used. On other platforms (such as
Linux), the directory \file{~/bin} is used. If these directories are not
writable, the directory \file{PhantomJS} under the installation directory of
the \pkg{webdriver} package will be tried. If this directory still fails, you
will have to install PhantomJS by yourself.
}
