% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtreat_coders.R
\name{piecewise_linear_coder}
\alias{piecewise_linear_coder}
\title{Piecewise linear fit coder factory.}
\usage{
piecewise_linear_coder(penalty = 1, min_n_to_chunk = 1000,
  min_seg = 10, max_k = 1000)
}
\arguments{
\item{penalty}{per-segment cost penalty.}

\item{min_n_to_chunk}{minimum n to subdivied problem.}

\item{min_seg}{positive integer, minimum segment size.}

\item{max_k}{maximum segments to divide into.}
}
\value{
a vtreat coder
}
\description{
Build a piecewise linear fit coder with some parameters bound in.
}
\examples{

coder <- piecewise_linear_coder(min_seg = 1)
coder("x", 1:8, c(1, 2, 3, 4, 4, 3, 2, 1))

}
