% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R
\name{cl_delete_corpus}
\alias{cl_delete_corpus}
\title{Drop loaded corpus.}
\usage{
cl_delete_corpus(corpus, registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{corpus}{name of a CWB corpus (upper case)}

\item{registry}{path to the registry directory, defaults to the value of the
environment variable CORPUS_REGISTRY}
}
\description{
Remove a corpus from the list of loaded corpora of the corpus library (CL).
}
\details{
The corpus library (CL) internally maintains a list of corpora including
information on positional and structural attributes so that the registry file
needs not be parsed again and again. However, when an attribute has been
added to the corpus, it will not yet be visible, because it is not part of
the data that has been loaded. The \code{cl_delete_corpus} function exposes a
CL function named identically, to force reloading the corpus (after it has
been deleted), which will include parsing an updated registry file.
}
